package Lire::ReportSpecFactory;

use strict;

use Lire::ReportSpec;
use Lire::FilterSpec;
use Lire::FilterExpr;
use Lire::Group;
use Lire::GroupField;
use Lire::GroupOp;
use Lire::Rangegroup;
use Lire::Records;
use Lire::Summary;
use Lire::Timegroup;
use Lire::Timeslot;

use vars qw( $VERSION );

BEGIN {
    ($VERSION)	= '$Revision: 1.10 $' =~ m!Revision: ([.\d]+)!;
}

sub new {
    my $proto = shift;
    my $class = ref $proto || $proto;

    bless {}, $class;
}

sub create_report_spec {
    my $self = shift;

    return new Lire::ReportSpec( @_ );
}

sub create_filter_spec {
    my $self = shift;

    return new Lire::FilterSpec( @_ );
}

sub create_ne_expr {
    my $self = shift;

    return new Lire::FilterExpr::Ne( @_ );
}

sub create_eq_expr {
    my $self = shift;

    return new Lire::FilterExpr::Eq( @_ );
}

sub create_lt_expr {
    my $self = shift;

    return new Lire::FilterExpr::Lt( @_ );
}

sub create_le_expr {
    my $self = shift;

    return new Lire::FilterExpr::Le( @_ );
}

sub create_gt_expr {
    my $self = shift;

    return new Lire::FilterExpr::Gt( @_ );
}

sub create_ge_expr {
    my $self = shift;

    return new Lire::FilterExpr::Ge( @_ );
}

sub create_match_expr {
    my $self = shift;

    return new Lire::FilterExpr::Match( @_ );
}

sub create_value_expr {
    my $self = shift;

    return new Lire::FilterExpr::Value( @_ );
}

sub create_not_expr {
    my $self = shift;

    return new Lire::FilterExpr::Not( @_ );
}

sub create_and_expr {
    my $self = shift;

    return new Lire::FilterExpr::And( @_ );
}

sub create_or_expr {
    my $self = shift;

    return new Lire::FilterExpr::Or( @_ );
}

sub create_group {
    my $self = shift;

    return new Lire::Group( @_ );
}

sub create_rangegroup {
    my $self = shift;

    return new Lire::Rangegroup( @_ );
}

sub create_summary {
    my $self = shift;

    return new Lire::Summary( @_ );
}

sub create_timegroup {
    my $self = shift;

    return new Lire::Timegroup( @_ );
}

sub create_timeslot {
    my $self = shift;

    return new Lire::Timeslot( @_ );
}

sub create_field {
    my $self = shift;

    return new Lire::GroupField( @_ );
}

sub create_sum {
    my $self = shift;

    return new Lire::GroupOp::Sum( @_ );
}

sub create_avg {
    my $self = shift;

    return new Lire::GroupOp::Avg( @_ );
}

sub create_min {
    my $self = shift;

    return new Lire::GroupOp::Min( @_ );
}

sub create_max {
    my $self = shift;

    return new Lire::GroupOp::Max( @_ );
}

sub create_count {
    my $self = shift;

    return new Lire::GroupOp::Count( @_ );
}

sub create_records {
    my $self = shift;

    return new Lire::Records( @_ );
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::FilterSpecFactory -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: ReportSpecFactory.pm,v 1.10 2002/05/20 20:15:14 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
