package Lire::WWW::UserAgent::OS;
#
# $Id: OS.pm,v 1.14 2002/06/14 16:22:03 flacoste Exp $
#
# The data in this module is taken from AWStats. (http://awstats.sf.net/)
# Rewritten by Egon Willighagen for LogReport.org (http://logreport.org/)
#
# Copyright (C) 2000, 2001 Laurent Destailleur <eldy@users.sourceforge.net>
# Copyright (C) 2001, 2002 Stichting LogReport Foundation <logreport@logreport.org>
#
#     This file is part of Lire.
#
#     Lire is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
#
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program (see COPYING); if not, check with
#     http://www.gnu.org/copyleft/gpl.html or write to the Free Software
#     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
#
use strict;
use vars qw/ $REVISION/;

BEGIN {
    $REVISION  = '$Id: OS.pm,v 1.14 2002/06/14 16:22:03 flacoste Exp $';
}

# -----------------------------------------------------------------------------
# Database
# -----------------------------------------------------------------------------

my %OSHash = (
# Windows family OS
"winme" => "Windows Me",
"winxp" => "Windows XP",
"win2000" => "Windows 2000",
"winnt" => "Windows NT",
"win98" => "Windows 98",
"win95" => "Windows 95",
"win9x" => "Windows 9x",
"win16" => "Windows 3.xx",
"wince" => "Windows CE",
"msie"  => "Windows",
# Other famous OS
"beos" => "BeOS",
"mac" => "Mac OS",
"os/2" => "OS/2 Warp",
"amigaos" => "AmigaOS",
# Unix like OS
"unix" => "Unknown Unix system",
"linux" => "GNU/Linux",
"aix" => "Aix",
"sunos" => "Sun Solaris",
"irix" => "Irix",
"osf" => "OSF Unix",
"hp-ux" => "HP Unix",
"netbsd" => "NetBSD",
"bsdi" => "BSDi",
"freebsd" => "FreeBSD",
"openbsd" => "OpenBSD",
"gnu/hurd" => "GNU/Hurd",
# Miscellanous OS
"webtv" => "WebTV",
"cp/m" => "CP/M",        # rumoured to be used by squid in http useragent field
"crayos" => "CrayOS",
"riscos" => "Acorn RISC OS",
"openvms" => "OpenVMS",
"debian"  => "Debian GNU/Linux",
"x11"	  => "Unknown X11 System",
);

my %OSAliasHash = 
  (
   "windows_me"	    => "winme",
   "windows_xp"	    => "winxp",
   "windows_2000"   => "win2000",
   "windows_nt_5"   => "win2000",
   "windows_nt"	    => "winnt",
   "windows-nt"	    => "winnt",
   "win32"	    => "winnt",
   "win_9x"	    => "win9x",
   "windows_98"	    => "win98",
   "windows_95"	    => "win95",
   "windows_31"	    => "win16",
   "windows_3.1"    => "win16",
   "windows;i;16"   => "win16",
   "windows_ce"	    => "wince",
);

my %CompiledOSHash	= map { $_ => qr/$_/; } keys %OSHash;

# -----------------------------------------------------------------------------
# Functions
# -----------------------------------------------------------------------------

sub getOS {
    my ($ua) = @_;
    my $rs1;
    my $rs2;

    $ua = lc $ua;
    if ($ua=~/win/) {
        foreach my $key (keys %OSAliasHash) {
	    if ( index( $ua, $key ) >= 0 ) {
                return $OSHash{$OSAliasHash{$key}};
	    }
        }
    }

    foreach my $key (keys %OSHash) {
	return $OSHash{$key} if index( $ua, $key ) >= 0;
    }

    return undef;
}

1;

