<?xml version="1.0" encoding="US-ASCII"?>

<!-- vim:syntax=dtd
                    -->

<!-- $Id: lire-types.mod,v 1.10 2002/07/12 22:51:35 flacoste Exp $ -->

<!--

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
     
You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

-->

<!-- 
    This module contains the parameter entity declarations for 
    the data types used by all Lire DTDs.

    All defined data types have a &lt;type>.type parameter entity 
    which defines their type as an XML type valid in an attribute
    declaration and a &lt;type>.name parameter entity that declare
    their name.

    Additionally, this module declares &lr;name>.types parameter
    entity that can be used to group types.

    In DTD driver files referring to this module, please use an entity
    declaration that uses the public identifier shown below:

    &lt;!ENTITY % lire-types.mod PUBLIC
    "-//LogReport.ORG//ENTITIES Lire Data Types V1.0//EN">
    %lire-types.mod;
                                                                   -->


<!-- =============================================================
                             BASIC TYPES
     ============================================================= -->

<!--
    The bool type.

    Contains a boolean value, either 0, 1, f, t, false or true.
                                                                   -->
<!ENTITY % bool.type         "0 | 1 | f | t | false | true | 
                              yes | no"                              >
<!ENTITY % bool.name         "bool"                                  >

<!--
    The int type.

    Contains positive or negative 32 bits integer
                                                                   -->
<!ENTITY % int.type          "CDATA"                                 >
<!ENTITY % int.name          "int"                                   >

<!--
    The string type.

    Contains any displayable text string.
                                                                   -->
<!ENTITY % string.type       "CDATA"                                 >
<!ENTITY % string.name       "string"                                >

<!--
    The number type.

    Contains any number. Either integral or floating point.
                                                                   -->
<!ENTITY % number.type       "CDATA"                                 >
<!ENTITY % number.name       "number"                                >

<!-- =============================================================
                        TIME &amp; DATE TYPES
     ============================================================= -->
<!--
    The timestamp type.

    This data type contains a time representation which contains
    the date and time informations. It can be represented in UNIX
    epoch time.
                                                                   -->
<!ENTITY % timestamp.type    "CDATA"                                 >
<!ENTITY % timestamp.name    "timestamp"                             >

<!--
    The time type.

    Contains a time representation which contains only the time of
    the day, not the date. For example, this data type can represent
    12h00, 15:13:10, etc.
                                                                   -->
<!ENTITY % time.type         "CDATA"                                 >
<!ENTITY % time.name         "time"                                  >

<!--
    The date type.

    Contains a time representation which contains only a date.
                                                                   -->
<!ENTITY % date.type         "CDATA"                                 >
<!ENTITY % date.name         "date"                                  >

<!--
    The duration type.

    Contains a quantity of time. For example : 5s, 30h, 2days,
    3w, 2M, 1y.  (The authoritive list of supported duration
    types is coded in &Lire::DataTypes::duration2sec .)
                                                                   -->
<!ENTITY % duration.type     "CDATA"                                 >
<!ENTITY % duration.name     "duration"                              >


<!-- =============================================================
                            INTERNET TYPES
     ============================================================= -->
<!--
    The IP type.

    Contains an IPv4 address.
                                                                   -->
<!ENTITY % ip.type           "CDATA"                                 >
<!ENTITY % ip.name           "ip"                                    >

<!--
    The port type.

    Contains a port as used in the TCP to name the ends of logical
    connections.  See also RFC 1700 and
    http://www.iana.org/numbers.htm.  Commonly found in /etc/services
    on Unix systems.
                                                                   -->
<!ENTITY % port.type         "CDATA"                                 >
<!ENTITY % port.name         "port"                                  >

<!--
    The hostname type.

    Contains an DNS hostname.
                                                                   -->
<!ENTITY % hostname.type     "NMTOKEN"                               >
<!ENTITY % hostname.name     "hostname"                              >

<!--
    The url type.

    Contains an URL.
                                                                   -->
<!ENTITY % url.type          "CDATA"                                 >
<!ENTITY % url.name          "url"                                   >

<!--
    The email type.

    A data type that can represent an email address.
                                                                   -->
<!ENTITY % email.type        "CDATA"                                 >
<!ENTITY % email.name        "email"                                 >

<!-- =============================================================
                             MISC TYPES
     ============================================================= -->
<!--
    The bytes type.

    Data type use to represent quantity of data. 
    (5m, 1.2g, 300bytes, etc.)
                                                                   -->
<!ENTITY % bytes.type        "CDATA"                                 >
<!ENTITY % bytes.name        "bytes"                                 >

<!--
    The filename type.

    Represent the name of a file or directory.
                                                                   -->
<!ENTITY % filename.type     "CDATA"                                 >
<!ENTITY % filename.name     "filename"                              >

<!-- =============================================================
                            SPECIAL TYPES
     ============================================================= -->

<!--
    The field type.

    This type contains a DLF field name. It is used in the parameter
    specification to represent a choice of sort field for example.
                                                                   -->
<!ENTITY % field.type        "NMTOKEN"                               >
<!ENTITY % field.name        "field"                                 >

<!--
    The superservice type.

    This type contains all defined superservice in Lire.
                                                                   -->
<!ENTITY % superservice.type "NMTOKEN"                               >
<!ENTITY % superservice.name "superservice"                          >

<!--
    The chart type.

    This type contains all defined chart types in Lire.
                                                                   -->
<!ENTITY % chart.type        "bars | lines | pie | histogram"        >
<!ENTITY % chart.name        "chart"                                 >

<!-- =============================================================
                             TYPES GROUPS
     ============================================================= -->
    
<!ENTITY % basic.types       "%bool.name; | %int.name; | 
                              %number.name; | %string.name;"         >
<!ENTITY % internet.types    "%email.name; | %url.name; | 
                              %ip.name; | %hostname.name; |
                              %port.name;"                           >
<!ENTITY % misc.types        "%filename.name; | %bytes.name; "       >
<!ENTITY % time.types        "%date.name; | %time.name; | 
                              %timestamp.name; | %duration.name;"    >

<!ENTITY % lire.types        "%basic.types; | %time.types; |
                              %internet.types; | %misc.types;"       >

