package Lire::AsciiDlf::Aggregator;

use strict;

use vars qw( $VERSION @ISA );

use Lire::Aggregator;
use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.4 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw( Lire::Aggregator );
}

sub dlf_sort_fields {
    my ( $self ) = shift;

    my @fields = ();
    foreach my $op ( @{$self->ops} ) {
	push @fields, $op->dlf_sort_fields;
    }

    return @fields;
}

# Initialize data
sub init_report {
    my ( $self, $dlf_info ) = @_;

    croak( ref $self, "::init_report unimplemented\n" );
}

sub update_report {
    my ( $self, $dlf ) = @_;

    croak( ref $self, "::update_report unimplemented\n" );
}

sub end_report {
    my ( $self ) = @_;

    croak(  ref $self , "::end_report unimplemented\n" );
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::AsciiDlf::Aggregator - Base implementation of Aggregators.

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: Aggregator.pm,v 1.4 2002/05/21 18:37:05 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
