package Lire::Extension;

use strict;

use vars qw( $VERSION );

use Lire::XMLUtils qw/xml_encode/;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.4 $' =~ m!Revision: ([.\d]+)!;
}

sub new {
    my $proto = shift;
    my $class = ref( $proto) || $proto;

    my %args = @_;

    delete $args{name};
    my $self = bless {
		      name   => $class,
		      params => \%args,
		     }, $class;
}

sub print {
    my ( $self, $fh, $pfx ) = @_;
    $pfx ||= 0;
    $fh  ||= \*STDOUT;

    my $class = ref $self;
    print $fh ' ' x $pfx, qq{<lire:extension name="$class"};

    while ( my ($name, $value) = each %{$self->{params}}) {
	print " ", $name, '="', xml_encode( $value ), '"';
    }
    print "/>\n\n";
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Extension -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: Extension.pm,v 1.4 2002/01/16 20:21:16 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
