package Lire::Extensions::Print::PrintSchema;

# vim:syntax=perl

use strict;

use vars qw($VERSION @ISA);

use Lire::AsciiDlf::ExtendedFieldsCreator;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.3 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw(Lire::AsciiDlf::ExtendedFieldsCreator);
}

sub init_computation {
    my ($self, $dlf_info) = @_;

    # Cache the fields' index
    $self->{'npages'} = $self->schema->field('num_pages')->pos;
    $self->{'ncopies'} = $self->schema->field('num_copies')->pos;
}

sub create_extended_fields {
    my ($self, $dlf) = @_;

    my $pages = $dlf->[$self->{'npages'}];
    my $copies = $dlf->[$self->{'ncopies'}];

	$copies = 1 if $copies eq 'LIRE_NOTAVAIL' || $copies < 1;

    my $sheets = $pages * $copies;

    return [ $sheets ];
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::PrintSchema -

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 VERSION

$Id: PrintSchema.pm,v 1.3 2002/07/12 21:18:13 ubiq Exp $

=head1 COPYRIGHT

Copyright (C) 2002 Stichting LogReport Foundation logreport@logreport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Wessel Dankers <wsl@logreport.org>

=cut
