package Lire::Merge::NestableAggregator;

use strict;

use vars qw( $VERSION @ISA %key_db %defined_keys );

use Lire::Report::Group;
use Lire::NestableAggregator;
use Lire::Merge::Aggregator;
use Lire::Merge::GroupOp;

BEGIN {
    ($VERSION)	= '$Revision: 1.3 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw( Lire::NestableAggregator Lire::Merge::Aggregator Lire::Merge::GroupOp);
}

sub init_merge {
    my $self = shift;

    $self->{data}   = $self->init_group_data;

    foreach my $op ( @{$self->{ops}}) {
	$op->init_merge(@_);
    }

    $self;
}

sub end_merge {
    my ( $self ) = @_;

    $self->end_group_data( $self->{data} );

    $self;
}

sub merge_entry_value {
    my ( $self, $value, $data ) = @_;

    die "value should be of type Lire::Report::Group, not $value\n"
      unless UNIVERSAL::isa( $value, "Lire::Report::Group" );

    $self->merge_entries( $value, $data );
}

sub add_entry_value {
    my ( $self, $entry, $data ) = @_;

    my $group = new Lire::Report::Group;
    $self->create_entries( $group, $data );
    $entry->add_group( $group );
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Merge::NestableAggregator -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: NestableAggregator.pm,v 1.3 2002/06/18 14:40:44 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
