package Lire::Merge::Summary;

use strict;

use vars qw/ $VERSION @ISA /;

use Lire::Summary;
use Lire::Merge::Aggregator;
use Lire::Report::Entry;

use Carp;

BEGIN {
    ($VERSION)	= '$Revision: 1.3 $' =~ m!Revision: ([.\d]+)!;
    @ISA = qw/ Lire::Summary Lire::Merge::Aggregator /;
}

sub init_merge {
    my ($self) = shift;

    $self->{data} = {};
    my $i = 0;
    foreach my $op ( @{$self->ops} ) {
	$op->init_merge(@_);
	$self->{data}{$op->name} = $op->init_group_data();
    }

    $self;
}

sub merge_entries {
    my ( $self, $group ) = @_;

    foreach my $e ( $group->entries ) {
	# First name will contains the summary operation's name
	# we should merge

	my @names = $e->names;
	die "too many names in summary's table\n"
	  if @names > 1;
	my @values = $e->values;
	die "too many values in summary's table\n"
	  if @values > 2; # One value, One group
	my $name = $names[0]{value};
	if ( exists $self->{data}{$name} ) {
	    my $op = $self->op_by_name( $name );

	    # Entries containing a group will have an empty value first
	    my $value = @values == 2 ? $values[1] : $values[0];
	    $op->merge_entry_value( $value, $self->{data}{$name} );
	} else {
	    warn "unknown operation: $name\n";
	}
    }

    $self;
}

sub end_merge {
    my ( $self ) = @_;

    my $i = 0;
    foreach my $op ( @{ $self->ops } ) {
	$op->end_group_data( $self->{data}{$op->name} );
    }

    $self;
}

sub create_entries {
    my ( $self, $group ) = @_;

    # FIXME: This needs to be updated to something more sensible
    # in the presentation upgrade.
    foreach my $op ( @{$self->ops} ) {
	my $entry = new Lire::Report::Entry;

	$entry->add_name( ucfirst $op->name, $op->name );
	$entry->add_value()
	  if UNIVERSAL::isa( $op, "Lire::NestableAggregator" );

	$op->add_entry_value( $entry, $self->{data}{$op->name} );

	$group->add_entry( $entry );
    }

    $self;
}


# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::Merge::Summary -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: Summary.pm,v 1.3 2002/06/18 14:40:44 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut
