#!/bin/sh -
# Copyright 2001 2002 Edson Brandi <ebrandi.home@uol.com.br>
# All Rights Reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY EDSON BRANDI ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT EDSON BRANDI BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
# OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.

DIALOG=${DIALOG=/usr/bin/dialog}

idioma() {

tempfile=`/usr/bin/mktemp -t checklist`

dialog --menu "FreeBSD LiveCD - Select your Language:" 12 60 4 \
        Br "Portuguese / Portugues" \
        En "English / Ingles" \
        Q "Quit / Sair" \
2> $tempfile 
        
opcao_idioma=`cat $tempfile`

case ${opcao_idioma} in
     Br)
     if [ -f ./lang/vnodes_Br ] ; then
     . ./lang/vnodes_Br
     else
     echo "Idioma selecionado nao disponivel"
     exit 1
     fi
     ;;
     En)
     if [ -f ./lang/vnodes_En ] ; then
     . ./lang/vnodes_En
     else
     echo "Sorry under implementation"
     exit 1
     fi
     ;;
     *)
     exit 1
     ;;
esac

}

mount_point() {
$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "$v_mount_1" 8 70 "" 2> /tmp/input.tmp.$$
retval=$?

mount_point=`cat /tmp/input.tmp.$$`
rm /tmp/input.tmp.$$

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0)
    if [ -f ${mount_point}/freebsd ]; then
 	menu   
    elif then
        mkdir ${mount_point}/freebsd
	menu
    fi
    ;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac

}

menu() {

tempfile=`/usr/bin/mktemp -t checklist`

# Define o menu principal
  log "menu()"
    dialog --menu "FreeBSD LiveCD - $v_menu_1" 18 70 11 \
        E "$v_menu_e" \
        H "$v_menu_h" \
        L "$v_menu_l" \
        R "$v_menu_r" \
        S "$v_menu_s" \
        T "$v_menu_t" \
        V "$v_menu_v" \
        X "$v_menu_x" \
        Q "$v_menu_q" \
2> $tempfile 
        
opcao=`cat $tempfile`

case ${opcao} in
     E)
     etc 
     ;;
     H)
     home 
     ;;
     L)
     local
     ;;
     R)
     root
     ;;
     S)
     swap
     ;;
     T)
     tmp 
     ;;
     V)
     var
     ;;
     X)
     x11r6
     ;;
     Q)
     rm $tempfile
     exit 0
     ;;
     *) 
     exit 0
     ;;
esac
}

etc() {

$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "$v_etc_1" 8 70 "" 2> /tmp/input.tmp.$$
retval=$?

etc=`cat /tmp/input.tmp.$$`
t_etc=`expr $etc \* 2 \* 1024`
rm /tmp/input.tmp.$$

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0)
    dd if=/dev/zero of=${mount_point}/freebsd/etc.flp bs=512 count=$t_etc
    cd /dev
    ./MAKEDEV vn4
    vnconfig -s labels -c vn4 ${mount_point}/freebsd/etc.flp
    disklabel -r -w vn4c auto
    newfs /dev/vn4c
    mount /dev/vn4c /mnt/tmp
    cd /mnt/tmp
    cp -Rp /etc/* .
    touch /mnt/tmp/XYZ123_
    cd /
    sleep 5
    umount /mnt/tmp
    vnconfig -u vn4
    #
    dialog --title "FreeBSD LiveCD" --msgbox "$v_etc_2" 5 60
    #
    menu
    ;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac


}

home() {

$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "$v_home_1" 8 70 "" 2> /tmp/input.tmp.$$
retval=$?

home=`cat /tmp/input.tmp.$$`
t_home=`expr $home \* 2 \* 1024`
rm /tmp/input.tmp.$$

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0) 
    dd if=/dev/zero of=${mount_point}/freebsd/home.flp bs=512 count=$t_home
    cd /dev
    ./MAKEDEV vn5
    vnconfig -s labels -c vn5 ${mount_point}/freebsd/home.flp
    disklabel -r -w vn5c auto
    newfs /dev/vn5c
    mount /dev/vn5c /mnt/tmp
    touch /mnt/tmp/XYZ123_
    umount /mnt/tmp
    vnconfig -u vn5
    #
    dialog --title "FreeBSD LiveCD" --msgbox "$v_home_2" 5 60
    #
    menu
    ;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac


}

local() {

$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "$v_local_1" 8 70 "" 2> /tmp/input.tmp.$$
retval=$?

local=`cat /tmp/input.tmp.$$`
t_local=`expr $local \* 2 \* 1024`
rm /tmp/input.tmp.$$

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0)
    dd if=/dev/zero of=${mount_point}/freebsd/local.flp bs=512 count=$t_local
    cd /dev
    ./MAKEDEV vn7
    vnconfig -s labels -c vn7 ${mount_point}/freebsd/local.flp
    disklabel -r -w vn7c auto
    newfs /dev/vn7c
    mount /dev/vn7c /mnt/tmp
    cd /mnt/tmp
#    cp -Rp /usr/local/* .
    touch /mnt/tmp/XYZ123_
    cd /
    sleep 5
    umount /mnt/tmp
    vnconfig -u vn7
    #
    dialog --title "FreeBSD LiveCD" --msgbox "$v_local_2" 5 60
    #
    menu
    ;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac

}

root() {

$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "v_root_1" 8 70 "" 2> /tmp/input.tmp.$$
retval=$?

root=`cat /tmp/input.tmp.$$`
t_root=`expr $root \* 2 \* 1024`
rm /tmp/input.tmp.$$

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0)
    dd if=/dev/zero of=${mount_point}/freebsd/root.flp bs=512 count=$t_root
    cd /dev
    ./MAKEDEV vn6
    vnconfig -s labels -c vn6 ${mount_point}/freebsd/root.flp
    disklabel -r -w vn6c auto
    newfs /dev/vn6c
    mount /dev/vn6c /mnt/tmp
    cd /mnt/tmp
    cp -Rp /root/* .
    touch /mnt/tmp/XYZ123_
    cd /
    sleep 5
    umount /mnt/tmp
    vnconfig -u vn6
    #
    dialog --title "FreeBSD LiveCD" --msgbox "$v_root_2" 5 60
    #
    menu
    ;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac

}

swap() {

$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "$v_swap_1" 8 70 "" 2> /tmp/input.tmp.$$
retval=$?

swap=`cat /tmp/input.tmp.$$`
t_swap=`expr $swap \* 2 \* 1024`
rm /tmp/input.tmp.$$

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0)
    dd if=/dev/zero of=${mount_point}/freebsd/swap.flp bs=512 count=$t_swap
    echo  swapfile=\"${mount_point}/freebsd/swap.flp\" >> /etc/rc.conf
    #
    dialog --title "FreeBSD LiveCD" --msgbox "$v_swap_2" 5 60
    #
    menu
    ;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac

}

tmp() {

$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "$v_tmp_1" 8 70 "" 2> /tmp/input.tmp.$$
retval=$?

tmp=`cat /tmp/input.tmp.$$`
t_tmp=`expr $tmp \* 2 \* 1024`
rm /tmp/input.tmp.$$

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0)
    dd if=/dev/zero of=${mount_point}/freebsd/tmp.flp bs=512 count=$t_tmp
    cd /dev
    ./MAKEDEV vn1
    vnconfig -s labels -c vn1 ${mount_point}/freebsd/tmp.flp
    disklabel -r -w vn1c auto
    newfs /dev/vn1c
    mount /dev/vn1c /mnt/tmp
    touch /mnt/tmp/XYZ123_
    cd /
    umount /mnt/tmp
    vnconfig -u vn1
    #
    dialog --title "FreeBSD LiveCD" --msgbox "$v_tmp_2" 5 60
    #
    menu
    ;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac

}

var() {

$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "$v_var_1" 8 70 "" 2> /tmp/input.tmp.$$
retval=$?

var=`cat /tmp/input.tmp.$$`
t_var=`expr $var \* 2 \* 1024`
rm /tmp/input.tmp.$$

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0)
    dd if=/dev/zero of=${mount_point}/freebsd/var.flp bs=512 count=$t_var
    cd /dev
    ./MAKEDEV vn3
    vnconfig -s labels -c vn3 ${mount_point}/freebsd/var.flp
    disklabel -r -w vn3c auto
    newfs /dev/vn3c
    mount /dev/vn3c /mnt/tmp
    killall syslogd
    cd /mnt/tmp
    cp -Rp /var/* .
    touch /mnt/tmp/XYZ123_
    cd /
    sleep 5
    umount /mnt/tmp
    vnconfig -u vn3
    #
    dialog --title "FreeBSD LiveCD" --msgbox "$v_var_2" 5 60
    #
    menu
    ;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac

}

x11r6() {

$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "$v_x11r6_1" 8 70 "" 2> /tmp/input.tmp.$$
retval=$?

x11r6=`cat /tmp/input.tmp.$$`
t_x11r6=`expr $x11r6 \* 2 \* 1024`
rm /tmp/input.tmp.$$

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0)
    dd if=/dev/zero of=${mount_point}/freebsd/x11r6.flp bs=512 count=$t_x11r6
    cd /dev
    ./MAKEDEV vn8
    vnconfig -s labels -c vn8 ${mount_point}/freebsd/x11r6.flp
    disklabel -r -w vn8c auto
    newfs /dev/vn8c
    mount /dev/vn8c /mnt/tmp
    cd /mnt/tmp
    cp -Rp /usr/X11R6/* .
    touch /mnt/tmp/XYZ123_
    cd /
    sleep 5
    umount /mnt/tmp
    vnconfig -u vn8
    #
    dialog --title "FreeBSD LiveCD" --msgbox "v_x11r6_2" 5 60
    #
    menu
    ;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac

}

idioma
mount_point
