#!/bin/sh
# Copyright 2001 2002 Edson Brandi <ebrandi.home@uol.com.br>
# All Rights Reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY EDSON BRANDI ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT EDSON BRANDI BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
# OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.

DIALOG=${DIALOG=/usr/bin/dialog}

idioma() {

tempfile=`/usr/bin/mktemp -t checklist`

dialog --menu "FreeBSD LiveCD - Select your Language:" 12 60 4 \
        Br "Portuguese / Portugues" \
        En "English / Ingles" \
        Q "Quit / Sair" \
2> $tempfile 
        
opcao_idioma=`cat $tempfile`

case ${opcao_idioma} in
     Br)
     if [ -f ./lang/install_Br ] ; then
     . ./lang/install_Br
     else
     echo "Idioma selecionado nao disponivel"
     exit 1
     fi
     ;;
     En)
     if [ -f ./lang/install_En ] ; then
     . ./lang/install_En
     else
     echo "Sorry under implementation"
     exit 1
     fi
     ;;
     *)
     exit 1
     ;;
esac

}

# Exibe o menu em dialog para selecao do HD

disco() {
dis="`dmesg | grep MB`"
disc="`echo $dis | awk -F":" '{print $1}'`"
desc="`echo $dis | awk -F":" '{print $2}'`"
tamanho="`echo $dis | awk '{print $2}' | awk -F"MB" '{print $1}'`"
$DIALOG --title "Escolha do device" --clear --checklist "$i_disco_1" 10 80 1 "$disc" "$desc" off 2> /tmp/input.tmp.$$
retval=$?

# Armazena a opcao do usuario na variavel $disco
disco=`cat /tmp/input.tmp.$$ | awk -F"\"" '{print $2}'`
rm /tmp/input.tmp.$$

# Trap que permite ao usuario cancelar o processo.

case $retval in
  0)
    raiz;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;

esac

}

# Exibe o menu em dialog perguntando ao usuario quantos MB ele deseja alocar para o /

raiz() {

$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "$i_raiz_1" 10 80 "" 2> /tmp/input.tmp.$$
retval=$?

# armazena a opcao do usuario na variavel $raiz
raiz=`cat /tmp/input.tmp.$$`
rm /tmp/input.tmp.$$

# Qualcula quantos MB ainda estao disponiveis para alocacao.
tamanho=`expr $tamanho - $raiz`

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0)
    swap;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac

}

# Exibe o menu em dialog perguntando ao usuario quantos MB ele deseja alocar para o swap
swap() {

$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "$i_swap_1" 10 80 "" 2> /tmp/input.tmp.$$
retval=$?

# armazena a opcao do usuario na variavel $swap
swap=`cat /tmp/input.tmp.$$`
rm /tmp/input.tmp.$$

# Qualcula quantos MB ainda estao disponiveis para alocacao.
tamanho=`expr $tamanho - $swap`

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0)
    var;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac

}

# Exibe o menu em dialog perguntando ao usuario quantos MB ele deseja alocar para o /var

var() {

$DIALOG --title "FreeBSD LiveCD" --clear --inputbox "$i_var_1" 10 80 "" 2> /tmp/input.tmp.$$
retval=$?

# armazena a opcao do usuario na variavel $var
var=`cat /tmp/input.tmp.$$`
rm /tmp/input.tmp.$$

# Qualcula quantos MB ainda estao disponiveis para alocacao.
tamanho=`expr $tamanho - $var`

# Trap que permite ao usuario cancelar o processo.
case $retval in
  0)
    usr;;
  1)
    echo "Cancel pressed.";;
  255)
    echo "ESC pressed.";;
esac
 
}

# Daqui para frente no  possivel abortar o processo!!!
# Exibe menu em dialog informando ao usuario que o espaco restante ser alocado no /usr

usr() {

$DIALOG --title " Atencao " --clear --msgbox "i_usr_1" -1 -1

# Define o tamanho da particao /usr em MB
usr=$tamanho

# Trap que permite ao usuario cancelar o processo.
case $? in
  0)
    confirma;;
  255)
    echo "ESC pressed.";;
esac

}

# Rotina de confirmacao
confirma() {

# Exibe alerta final
dialog --title "FreeBSD LiveCD" --yesno "i_confirma_1" 8 70 || exit 1

prepara

}

# rotina de instalacao
prepara() {

# Apaga as particoes do disco
/bin/dd if=/dev/zero of=/dev/$disco count=128
sleep 5

# Informa que sera usado o disco inteiro
/sbin/fdisk -I $disco
sleep 5

# Inicializa o disco
/sbin/disklabel -rw ${disco}s1 auto
sleep 5

# Cria as particaoes no disco.
modelo=/tmp/label.modelo
/sbin/disklabel -r ${disco}s1 > $modelo

# Define o numero de blocos disponiveis no disco
setores_disco=`/sbin/disklabel -r ${disco}s1 | /usr/bin/tr -s ' ' | \
          /usr/bin/sed 's/^ //g' | /usr/bin/grep '^c: ' | \
          /usr/bin/cut -f2 -d' '`

# Define o numero de blocos de cada slice
b_raiz=`expr $raiz \* 1024 \* 2`
b_swap=`expr $swap \* 1024 \* 2`
b_var=`expr $var \* 1024 \* 2`
b_usr=`expr $setores_disco \- $b_raiz \- $b_swap \- $b_var`

# Define o offset dos slices /var e /usr
off_var=`expr $b_raiz \+ $b_swap`
off_usr=`expr $b_raiz \+ $b_swap \+ $b_var`

# Prepara o modelo que sera usado pelo disklabel
echo "a: $b_raiz 0 4.2BSD 0 0 0" >>  $modelo
echo "b: $b_swap $b_raiz swap" >>  $modelo 
echo "e: $b_var $off_var 4.2BSD 0 0 0"  >>  $modelo  
echo "g: $b_usr $off_usr 4.2BSD 0 0 0"  >>  $modelo 

# Cria as particoes no disco e seta o mesmo como "bootavel"
/sbin/disklabel -R -B ${disco}s1 $modelo
sleep 5

# Gera o sistema de arquivos no /
/sbin/newfs /dev/${disco}s1a
sleep 5

# Gera o sistema de arquivos no /var
/sbin/newfs /dev/${disco}s1e
sleep 5

# Gera o sistema de arquivos no /usr
/sbin/newfs /dev/${disco}s1g

# Cria os devices caso eles nao existam.
if [ ! -c /dev/${disco} ]; then
  (cd /dev && MAKEDEV ${disco})
fi

if [ ! -c /dev/${disco}s1 ]; then
  (cd /dev && MAKEDEV ${disco}s1)
fi

if [ ! -c /dev/${disco}s1a ]; then
  (cd /dev && MAKEDEV ${disco}s1a)
fi

if [ ! -c /dev/${disco}s1b ]; then
  (cd /dev && MAKEDEV ${disco}s1b)
fi

if [ ! -c /dev/${disco}s1e ]; then
  (cd /dev && MAKEDEV ${disco}s1e)
fi

if [ ! -c /dev/${disco}s1g ]; then
  (cd /dev && MAKEDEV ${disco}s1g)
fi

# monta o disco 
/sbin/mount /dev/${disco}s1a /mnt
sleep 5
mkdir /mnt/usr

/sbin/mount /dev/${disco}s1g /mnt/usr
sleep 5
mkdir /mnt/var

/sbin/mount /dev/${disco}s1e /mnt/var
sleep 5

# Ativa o swap.
swapon /dev/${disco}s1b

# Copia os arquivos do LiveCD para o disco rigido.
cd /mnt
for i in bin boot bootstrap dev etc home modules root sbin stand tmp var
do
  cp -Rvp /$i .
  sleep 5
done

cp /.cshrc /mnt
sleep 2
cp /.profile /mnt
sleep 2
cp /COPYRIGHT /mnt
sleep 2
cp /dist/fstab.install /mnt/etc/fstab
sleep 2
cp /dist/rc /mnt/etc/rc
sleep 2

cd /mnt/usr
for i in bin games include lib libdata libexec local obj sbin share src
do
  cp -Rvp /usr/$i .
  sleep 5
done

# recria todos os devices
cd /mnt/dev
./MAKEDEV all

# copia o kernel para o / do disco rigido
cp /dist/kernel /mnt/kernel
cp /dist/kernel /mnt/kernel.GENERIC

# Ajusta as permissoes dos arquivos recem copiados e cria disretorios faltantes.
mtree -deU -f /dist/LiveCD.mtree -p /mnt > /dev/null &&

# Define qual particao sera usada para montagem do /
echo rootdev="${disco}s1a" >> /mnt/boot/loader.conf

cd /

sleep 30

# desmonta o disco atual
/sbin/umount /mnt/usr
/sbin/umount /mnt/var
/sbin/umount /mnt

touch /tmp/install_ok

}

aviso() {

if [ -f /tmp/install_ok ] ; then
# Informa ao usuario que o processo foi concluido
dialog --title "FreeBSD LiveCD" --msgbox "$i_informa_1" 8 70
fi

}

# Atencao!!!!
# 
# A execucao em modo batch NAO pede confirmacao, use com cuidado!!!
#
# Para usar em modo batch batch , basta executar o comando com 4 parametros:
# instalar_frebsd.sh disco raiz swap var, por ex: 
# instalar_freebsd.sh ad0 200 256 2000, instala o freebsd criando 
# - / com 200MB
# - swap com 2256MB
# - /var com 2GB
# - /usr com o restante do disco
# Se executar com menos de 4 parametros entra em modo interativo.

if [ "$#" -lt 4 ] ; then
   idioma
   disco 
   aviso
elif then
   disco=$1
   raiz=$2
   swap=$3
   var=$4 
   prepara
fi
