#!/usr/bin/perl -w

# mailgraph -- a postfix statistics rrdtool frontend
# copyright (c) 2000, 2001, 2002 David Schweikert <dws@ee.ethz.ch>
# released under the GNU General Public License

use RRDs;
use POSIX qw(uname);

my $VERSION = 0.20;

my $host = (POSIX::uname())[1];
my $scriptname = 'mailgraph.cgi';
my $xpoints = 540;
my $ypoints = 150;
my $ypoints_err = 80;
my $rrd = 'mailgraph.rrd'; # path to where the RRD database is
my $rrd_virus = 'mailgraph_virus.rrd'; # path to where the Virus RRD database is
my $tmp_dir = '/tmp/mailgraph'; # temporary directory where to store the images

my @graphs = (
	{ title => 'Day Graph',   seconds => 3600*24,        },
	{ title => 'Week Graph',  seconds => 3600*24*7,      },
	{ title => 'Month Graph', seconds => 3600*24*31,     },
	{ title => 'Year Graph',  seconds => 3600*24*365, },
);

sub graph($$$)
{
	my $range = shift;
	my $file = shift;
	my $title = shift;

	my ($graphret,$xs,$ys) = RRDs::graph($file,
		'--imgformat', 'PNG',
		'--width', $xpoints,
		'--height', $ypoints,
		'--start', "-$range",
		'--end', "-".int($range*0.01),
		'--vertical-label', 'msgs/min',
		'--title', $title,
		'--lazy',
		"DEF:sent=$rrd:sent:AVERAGE",
		"DEF:recv=$rrd:recv:AVERAGE",
		"DEF:msent=$rrd:sent:MAX",
		"DEF:mrecv=$rrd:recv:MAX",
		"CDEF:rsent=sent,60,*",
		"CDEF:rrecv=recv,60,*",
		"CDEF:rmsent=msent,60,*",
		"CDEF:rmrecv=mrecv,60,*",
		"CDEF:vsent=sent,UN,0,sent,IF,$range,*",
		"CDEF:vrecv=recv,UN,0,recv,IF,$range,*",
		'AREA:rsent#000099:Sent',
		'GPRINT:vsent:AVERAGE:total\: %.0lf msgs',
		'GPRINT:rmsent:MAX:max\: %.0lf msgs/min',
		'LINE2:rrecv#009900:Received',
		'GPRINT:vrecv:AVERAGE:total\: %.0lf msgs',
		'GPRINT:rmrecv:MAX:max\: %.0lf msgs/min\l',
		'HRULE:0#000000',
		'COMMENT:\s',
		'COMMENT:graph created on '.localtime(time).'\r',
	);
	my $ERR=RRDs::error;
	die "ERROR: $ERR\n" if $ERR;
}

sub graph_err($$$)
{
	my $range = shift;
	my $file = shift;
	my $title = shift;

	my ($graphret,$xs,$ys) = RRDs::graph($file,
		'--imgformat', 'PNG',
		'--width', $xpoints,
		'--height', $ypoints_err,
		'--start', "-$range",
		'--end', "-".int($range*0.01),
		'--vertical-label', 'msgs/hour',
		'--title', "$title of Errors",
		'--lazy',
		"DEF:bounced=$rrd:bounced:AVERAGE",
		"DEF:rejected=$rrd:rejected:AVERAGE",
		"DEF:virus=$rrd_virus:virus:AVERAGE",
		"DEF:spam=$rrd_virus:spam:AVERAGE",
		"DEF:mbounced=$rrd:bounced:MAX",
		"DEF:mrejected=$rrd:rejected:MAX",
		"DEF:mvirus=$rrd_virus:virus:MAX",
		"DEF:mspam=$rrd_virus:spam:MAX",
		"CDEF:rbounced=bounced,3600,*",
		"CDEF:rrejected=rejected,3600,*",
		"CDEF:rvirus=virus,3600,*",
		"CDEF:rspam=spam,3600,*",
		"CDEF:vbounced=bounced,UN,0,bounced,IF,$range,*",
		"CDEF:vrejected=rejected,UN,0,rejected,IF,$range,*",
		"CDEF:vvirus=virus,UN,0,bounced,IF,$range,*",
		"CDEF:vspam=spam,UN,0,rejected,IF,$range,*",
		"CDEF:rmbounced=mbounced,60,*",
		"CDEF:rmrejected=mrejected,60,*",
		"CDEF:rmvirus=mvirus,60,*",
		"CDEF:rmspam=mspam,60,*",
		'LINE2:rbounced#000000:Bounced',
		'GPRINT:vbounced:AVERAGE:total\: %.0lf msgs',
		'GPRINT:rmbounced:MAX:max\: %.0lf msgs/min',
		'LINE2:rrejected#BB0000:Rejected',
		'GPRINT:vrejected:AVERAGE:total\: %.0lf msgs',
		'GPRINT:rmrejected:MAX:max\: %.0lf msgs/min\l',
		'LINE2:rvirus#BB00A0:Viruses',
		'GPRINT:vvirus:AVERAGE:total\: %.0lf msgs',
		'GPRINT:rmvirus:MAX:max\: %.0lf msgs/min',
		'LINE2:rspam#BBA000:SPAM',
		'GPRINT:vspam:AVERAGE:total\: %.0lf msgs',
		'GPRINT:rmspam:MAX:max\: %.0lf msgs/min\l',
		'HRULE:0#000000',
		'COMMENT:\s',
		'COMMENT:graph created on '.localtime(time).'\r',
	);
	my $ERR=RRDs::error;
	die "ERROR: $ERR\n" if $ERR;
}

sub print_html()
{
	print "Content-Type: text/html\n\n";

	print <<HEADER;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
<HTML>
<HEAD>
<TITLE>Mail Statistics for $host</TITLE>
</HEAD>
<BODY BGCOLOR="#FFFFFF">
HEADER

	print "<H1>Mail Statistics for $host</H1>\n";
	for my $n (0..$#graphs) {
		print "<H2>$graphs[$n]{title}</H2>\n";
		print "<P><IMG BORDER=\"0\" SRC=\"$scriptname/mailgraph_${n}.png\" ALT=\"mailgraph\">\n";
		print "<P><IMG BORDER=\"0\" SRC=\"$scriptname/mailgraph_${n}_err.png\" ALT=\"mailgraph\">\n";
	}

	print <<FOOTER;
<table border="0" width="400"><tr><td align="left">
<A href="http://people.ee.ethz.ch/~dws/software/mailgraph">Mailgraph</A> $VERSION
by <A href="http://people.ee.ethz.ch/~dws/">David Schweikert</A></td>
<td ALIGN="right">
<a HREF="http://people.ee.ethz.ch/~oetiker/webtools/rrdtool/"><img border="0" src="http://people.ethz.ch/~oetiker/webtools/rrdtool/.pics/rrdtool.gif" alt="" width="120" height="34"></a>
</td></tr></table>
</BODY>
FOOTER
}

sub send_image($)
{
	my $file = shift;
	-r $file or do {
		print "Content-Type: text/plain\n\nERROR: can't find $file\n";
		exit 1;
	};

	print "Content-Type: image/png\n";
	print "Content-Length: ".((stat($file))[7])."\n";
	print "\n";
	open(IMG, $file) or die;
	my $data;
	print $data while read IMG, $data, 1024;
}

sub main()
{
	if($ENV{PATH_INFO}) {
		my $uri = $ENV{REQUEST_URI};
		$uri =~ s/\/[^\/]+$//;
		$uri =~ s/\//,/g;
		$uri =~ s/\~/tilde,/g;
		mkdir $tmp_dir, 0777 unless -d $tmp_dir;
		mkdir "$tmp_dir/$uri", 0777 unless -d "$tmp_dir/$uri";
		my $file = "$tmp_dir/$uri$ENV{PATH_INFO}";
		if($ENV{PATH_INFO} =~ /^\/mailgraph_(\d+)\.png$/) {
			graph($graphs[$1]{seconds}, $file, $graphs[$1]{title});
		}
		elsif($ENV{PATH_INFO} =~ /^\/mailgraph_(\d+)_err\.png$/) {
			graph_err($graphs[$1]{seconds}, $file, $graphs[$1]{title});
		}
		else {
			print "Content-Type: text/plain\n\nERROR: unknown image $ENV{PATH_INFO}\n";
			exit 1;
		}
		send_image($file);
	}
	else {
		print_html;
	}
}

main;
