#! /usr/bin/env python
#
# Copyright (c) 2001 by Dale Weber <software@dynaplex.net>  ALL rights reserved.
#
# System maintenance backup script for FreeBSD 4.2 or later.
#
# Author    : Dale Weber <software@dynaplex.net>
# Version   : 0.5.0
# Language  : Python 2.0
# Date      : 21-Apr-2001
# Changes   : Original Release
#
# Version   : 0.5.1
# Date      : 23-Apr-2001
# Changes   : Fixed paths
#
# Version   : 0.5.2
# Date      : 29-Apr-2001
# Changes   : Added verbose switch for running from cron (quiet) and 
#               interactively (shows output)
#           : Fixed logging to be consistant with other modules
#
# Calls     : None
# Called by : maint

############################################################
# Initialize
############################################################
import os, sys, maintlib;

# General
params = maintlib.getparams (sys.argv[0:]);
progname = params[0];

# Handle no params
if ( len(params) < 3 ):
        print "Usage: " + os.path.basename (progname) + " logfile [selections]";
        print "       selections may be:";
        print "         all OR [downloads ports source]";
        sys.exit (1);

maintlog = params[1];
maintconfdir = params[2];
verbose = params[3];

ignore = [ progname, maintlog, maintconfdir, verbose ];

# Strip logfile and progname from params.
for p in ignore:
	params.remove(p);

backupdir = "/backup/";
portsdir = "/usr/ports/";
distfilesdir = "/distfiles";

tarext = ".tar.gz";

if ( verbose == "yes" ):
	taropt = "-zvcf";
else:
	taropt = "-zcf";

tarcmd = "tar " + taropt + " " + backupdir;

portsopts = ""

musicfname = "music" + tarext;

portsfname = "ports" + tarext;

sourcefname1 = "source1" + tarext;
sourcefname2 = "source2" + tarext;

sysfname1 = "system1" + tarext;
sysfname2 = "system2" + tarext;
sysfname3 = "system3" + tarext;
sysfname4 = "system4" + tarext;
sysfname5 = "system5" + tarext;

dlfname1 = "download1" + tarext;
dlfname2 = "download2" + tarext;
dlfname3 = "download3" + tarext;
dlfname4 = "download4" + tarext;

log = open (maintlog, "a");

maintlib.writelog (log, "");
maintlib.writelog (log, "Starting Backup(s)");

#############################################################
# Do the work..
#############################################################

if ( params[0] == "all" ):
	params = [ "ports", "source", "system", "downloads", "music" ];

for sel in params:
	maintlib.writelog (log, "");
	maintlib.writelog (log, "Backing up " + sel);

	os.chdir (backupdir);

	if ( sel == "ports" ):
		if os.path.exists (portsfname):
			os.remove(portsfname);

		#
		# Make backups from root (/)
		#

		os.chdir ("/");

		cmd = "tar " + portsopts + " " + taropt + " " + backupdir + portsfname + " usr/ports";
		os.system(cmd);
	elif ( sel == "source" ):
		for src in [ sourcefname1, sourcefname2 ]:
			if os.path.exists (src):
				os.remove(src);

		os.chdir ("/");

		cmd = tarcmd + sourcefname1 + " usr/src";
		os.system(cmd);
		cmd = tarcmd + sourcefname2 + " usr/local/src";
		os.system (cmd);
	elif ( sel == "system" ):
		for sys in [ sysfname1, sysfname2, sysfname2, sysfname3, sysfname4, sysfname5 ]:
			if os.path.exists (sys):
				os.remove (sys);

		os.chdir ("/");

		cmd = tarcmd + sysfname1 + " boot etc home root";
		os.system (cmd);
		cmd = tarcmd + sysfname2 + " var usr/local/{etc,share}";
		os.system (cmd);
		cmd = tarcmd + sysfname3 + " usr/X11R6/share/[A-Z,a-f]*";
		os.system (cmd);
                cmd = tarcmd + sysfname4 + " usr/X11R6/share/[g-z]*";
                os.system (cmd);
	elif ( sel == "downloads" ):
		for dl in [ dlfname1, dlfname2, dlfname3, dlfname4 ]:
			if os.path.exists (dl):
				os.remove (dl);

		os.chdir ("/");

		cmd = tarcmd + dlfname1 + " usr/local/downloads/[a-s,u-z,]*";
		os.system (cmd);
		cmd = tarcmd + dlfname2 + " usr/local/downloads/themes/{[a-d]*,[f-z]*}";
		os.system (cmd);
                cmd = tarcmd + dlfname3 + " usr/local/downloads/themes/e";
                os.system (cmd);
	elif ( sel == "music" ):
		if os.path.exists (musicfname):
			os.remove (musicfname);

		os.chdir ("/");

		cmd = tarcmd + musicfname + " usr/local/music";
		os.system (cmd);

	# End elif

	maintlib.writelog (log, "Finished backing up " + sel);

# End for

log.close;
