#! /usr/bin/env python
#
# Copyright (c) 2001
#            Dale A. Weber, Oregon  97217.  
#        All rights reserved.
#    
#    Redistribution and use in source and binary forms, with or without
#    modification, are permitted provided that the following conditions
#    are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer as
#       the first lines of this file unmodified.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    
#    THIS SOFTWARE IS PROVIDED BY %%your_name_here%% ``AS IS'' AND ANY EXPRESS OR
#    IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
#    OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#    IN NO EVENT SHALL %%your_name_here%% BE LIABLE FOR ANY DIRECT, INDIRECT,
#    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#    NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#              
#            $Id: maint-build.py,v 1.6 2001/04/29 18:35:00 kermutt Exp $
#
# System maintenance build script for FreeBSD 4.2 or later.
#
# Author    : Dale Weber <software@dynaplex.net>
# Version   : 0.5.0
# Language  : Python 2.0
# Date      : 21-Apr-2001
# Changes   : Original Release
#
# Version   : 0.5.2
# Date      : 29-Apr-2001
# Changes   : Fixed ports temp file deletion, Added verbose switch for
#             running from cron (quiet) or interactively (shows output) 
#
# Version   :
# Date      :
# Changes   :
#
# Calls     : maint-build-kde2.csh, maint-build-system.csh, and
#             maint-build-system2.csh
#
# Called by : maint.py

############################################################
# Initialize
############################################################
import os, sys, string, maintlib;

# General
params = maintlib.getparams (sys.argv[0:]);
progname = params[0];
maintlog = params[1];
maintdatadir = params[2];
verbose = params[3];

ignore = [ progname, maintlog, maintdatadir, verbose ];

# Handle no params
if ( len(params) < 1 ):
        print "Usage: " + os.path.basename (progname) + " logfile [selections]";
        print "       selections may be:";
        print "         all OR [freebsd kernel kde2 readmes system]";
        sys.exit (1);

# Strip progname, maintlog, and maintdatadir from params.
for p in ignore:
	params.remove (p);

maintlogdir = string.replace (maintdatadir, "data", "logs");

portsdeps = maintdatadir + "portsdeps";
portsdepstmp = portsdeps + ".tmp"
packages = maintdatadir + "packages";

portscleanlog = maintlogdir + "maint-clean-ports.log";
readmeslog = maintlogdir + "/maint-build-readmes.log"

portsdir = "/usr/ports";

log = open (maintlog, "a");

maintlib.writelog (log, "");
maintlib.writelog (log, "Starting Build(s)");

#############################################################
# Do the work..
#############################################################

if ( params[0] == "all" ):
	params = [ "portsdeps", "readmes", "freebsd", "kernel" ];

	if (verbose == "yes" ):
		outlog = "";
	else:
		outlog = " > /dev/null";

for sel in params:
	maintlib.writelog (log, "");
	maintlib.writelog (log, "Building " + sel);

	if ( sel == "freebsd" ):
		os.chdir ("/usr/src");
		os.system ("make world" + outlog);
	elif ( sel == "kde2" ):
		os.system(maint-build-kde2.csh);
	elif ( sel == "kernel" ):
		os.chdir ("/sys/i386/conf");
		cmd = "config " + os.environ['KERNCONF'];
		os.system (cmd);
		dir =  "../../compile/" + os.environ['KERNCONF'];
		os.chdir (dir);
		os.system ("make depend" + outlog);
		os.system ("make" + outlog);
		os.system ("make install" + outlog);
	elif ( sel == "portsdeps" ):
		maintlib.writelog (log, "");
		maintlib.writelog (log, "Creating new ports dependency data");

		os.chdir (maintdatadir);

		cmd = "cat " + portscleanlog + ' | sed -e "s#===>  Cleaning for #D #g" > ' + portsdepstmp;
		os.system (cmd);

		cmd = "cat " + portsdepstmp + ' | sed -e "s#===> #P #g" > ' + portsdeps;
		os.system (cmd);

		maintlib.writelog (log, "Creating new package list");
		os.system ('cat portsdeps | grep \/ | sed -e "s#P ##g" > ' + packages);
		if os.path.exists (portsdepstmp):
			os.remove (portsdepstmp);
	elif ( sel == "readmes" ):
		os.chdir ("/usr/ports");
		cmd = "make readmes > " + readmeslog;  
		os.system (cmd);
	elif ( sel == "system" ):
		os.system ("maint-build-system.csh");

	# End elif

	maintlib.writelog (log, "Finished building " + sel);

log.close;

sys.exit (0);
