#! /usr/bin/env python
#
# Copyright (c) 2001
#            Dale A. Weber, Oregon  97217.  
#        All rights reserved.
#    
#    Redistribution and use in source and binary forms, with or without
#    modification, are permitted provided that the following conditions
#    are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer as
#       the first lines of this file unmodified.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    
#    THIS SOFTWARE IS PROVIDED BY %%your_name_here%% ``AS IS'' AND ANY EXPRESS OR
#    IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
#    OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#    IN NO EVENT SHALL %%your_name_here%% BE LIABLE FOR ANY DIRECT, INDIRECT,
#    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#    NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#              
#            $Id: maint.py,v 1.8 2001/04/28 15:09:46 kermutt Exp $
#
# System maintenance scripts for FreeBSD 4.2 or later.
#
# Author    : Dale Weber <software@dynaplex.net>
# Version   : 0.5.0
# Language  : Python 2.0
# Date      : 22-Apr-2001
# Changes   : Original Release
#
# Requires: Python 2.0 (May work with 1.5.2), and the usual suite
#           of UNIX utilities (sed, grep, tar, bzip, etc).
#
# Date    :
# Changes :

############################################################
# Initialize
############################################################
import os, sys, string, time, maintlib;

#
# General
#
params = maintlib.getparams (sys.argv[0:]);
progname = params[0];

#
# Handle call with no parameters - print usage message.
#

if ( len(params) > 1 ):
	frequency = params[1];
else:
	print "Usage: " + os.path.basename (progname) + " operation [selections]";
	print "";
	print "   operation MUST be ONE of [backup build clean restore update]";
	print "";
	print "   selections are:"
	print "      for operation == backup: all OR [downloads ports source]";
	print "      for operation == build: all OR [readmes freebsd kernel]"
	print "      for operation == clean: all OR [ports source]"
	print "      for operation == restore: all OR [ports source system downloads music]"
	print "      for operation == update: all OR [ports source kde2]"
	sys.exit (1);

# End else

#
# Initalize paths - will eventually get these from maint.conf
#

prefix = "/usr/local";

maintdir = prefix + "/share/maint/";
maintconfdir = prefix + "/etc/maint";

maintlogdir = maintdir + "logs/";
maintdatadir = maintdir + "data/";

if frequency in [ "daily", "weekly", "monthly", "yearly", "special" ]:
	maintprefix = frequency;
	operation = "";
	ignore = [ frequency, progname ];

	if ( frequency == "special" ):
		verbose = "yes";
	else:
		verbose = "no";
else:
	operation = params[1];
	frequency = "";
	maintprefix = "maint";
	ignore = [ operation, progname ];
	verbose = "yes";

# End else

#
# Remove the first parameters, since they have already been parsed out.
#
for p in ignore:
        params.remove(p);

#
# Setup the log file
#
maintlog = maintlogdir + maintprefix + "." + maintlib.filedate() + ".log";

#############################################################
# Do the work..
#############################################################

maintlib.init (maintlog);
log = open(maintlog, "a");

if ( frequency == "" ):
	cmd = maintlib.newcmd (log, progname, params, operation, maintlog , maintconfdir, maintdatadir, verbose);

	log.close;

	if ( cmd == "ERROR" ):
		sys.exit (3);

	#
	# Execute the command
	#
	retval = os.system (cmd);
else:
	#
	# Process periodic batch file
	#
	
	inpfile = maintconfdir + "/" + frequency + ".conf"

	cmdprefix = "maint " + frequency + " " + maintlog;

	#
	# Do the actual work
	#

	inp = open (inpfile, "r");
	line = string.strip (inp.readline());

	while ( line <> "" ):
		params = string.split (line, " ");
		operation = params[0];

		params = params[1:];
		cmd = maintlib.newcmd (log, progname, params, operation, maintlog, maintconfdir, maintdatadir, verbose);

		log.close;

		if ( cmd == "ERROR" ):
			sys.exit (3);

		retval = os.system (cmd);
		line = string.strip (inp.readline());

	# End while

	inp.close;

# End else

sys.exit (0)
