#! /bin/csh
#
# Copyright (c) 2001
#            Dale A. Weber, Oregon  97217.  
#        All rights reserved.
#    
#    Redistribution and use in source and binary forms, with or without
#    modification, are permitted provided that the following conditions
#    are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer as
#       the first lines of this file unmodified.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    
#    THIS SOFTWARE IS PROVIDED BY %%your_name_here%% ``AS IS'' AND ANY EXPRESS OR
#    IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
#    OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#    IN NO EVENT SHALL %%your_name_here%% BE LIABLE FOR ANY DIRECT, INDIRECT,
#    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#    NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#              
#            $Id: maint-build-kde2.csh,v 1.3 2001/04/28 15:09:45 kermutt Exp $

set kde2root=$1
set kde2pkgs `ls ${kde2root}`
set log=$2

setenv		kde2first	"kdesupport kdelibs kdeadmin kdebase "
setenv		kde2ignore	""
setenv		stdopt		"--prefix=$KDEDIR"
setenv		options		""

echo "`date`: Starting build of KDE 2.1" >> ${log}

#
# Remove the packages that must be built first, from the list
#
foreach pkg ( $kde2first $kde2ignore )
	setenv	kde2pkgs	`echo $kde2pkgs|sed -e "s/$pkg //g"`;
end

#
# Get our list of packages to build in the right order
#
setenv		kde2pkgs	"${kde2first} ${kde2pkgs}"

#
# Move to the KDE 2.1 source root directory
#
cd ${kde2root}

#
# Build and install the packages
#
foreach pkg ( $kde2pkgs )
        echo "`date`:" >> $log
	echo "`date`: Starting build of KDE 2 package $pkg" >> $log

	switch ( $pkg )
		case kdeadmin:
			setenv options "--with-rpm --with-pam=yes";
			breaksw

		case kdebase:
			setenv options "--with-shadow --with-pam=yes";
			breaksw

		case kdebindings:
			setenv options "--with-pythondir=/usr/local";
			breaksw

		case kdegames:
			breaksw

		case kdegraphics:
			setenv options	"--with-gphoto2-libraries=/usr/X11R6/lib --with-gphoto2-includes=/usr/X11R6/include";
			breaksw

		case kdelibs:
			setenv options "--enable-mysql";
			breaksw

		case kdemultimedia:
			breaksw

		case kdenetwork:
			breaksw

		case kdepim:
			breaksw

		case kdesdk:
			breaksw

		case kdesupport:
			breaksw

		case kdetoys:
			breaksw

		case kdeutils:
			breaksw

		case kdevelop:
			breaksw

		case kdoc:
			breaksw

		case kmusic:
			breaksw

		case koffice:
			breaksw

		default:
			setenv options ""
			breaksw
	endsw

	cd $kde2root/$pkg;

	if ( -f Makefile.cvs ) then
		gmake -f Makefile.cvs;
	endif

	echo "`date`: Configuring $pkg" >> $log

	./configure ${stdopt} ${options};

	echo "`date`: Building package $pkg" >> ${log}

	gmake;

	echo "`date`: Installing package $pkg" >> ${log}

	gmake install;

	echo "`date`: Cleaning up for package $pkg" >> ${log}

	gmake clean;

	echo "`date`: Finished building KDE 2 package $sel" >> $log;
end

echo "`date`:" >> $log
echo "`date`: Finished build of KDE 2" >> $log
