#! /usr/bin/env python
#
# Copyright (c) 2001
#            Dale A. Weber, Oregon  97217.  
#        All rights reserved.
#    
#    Redistribution and use in source and binary forms, with or without
#    modification, are permitted provided that the following conditions
#    are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer as
#       the first lines of this file unmodified.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    
#    THIS SOFTWARE IS PROVIDED BY %%your_name_here%% ``AS IS'' AND ANY EXPRESS OR
#    IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
#    OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#    IN NO EVENT SHALL %%your_name_here%% BE LIABLE FOR ANY DIRECT, INDIRECT,
#    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#    NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#              
#            $Id: maint-restore.py,v 1.5 2001/04/29 18:35:00 kermutt Exp $
#
# System maintenance restore script for FreeBSD 4.2 or later.
#
# Author    : Dale Weber <software@dynaplex.net>
# Version   : 0.5.0
# Language  : Python 2.0
# Date      : 21-Apr-2001
# Changes   : Original Release
#
# Version   : 0.5.2
# Date      : 29-Apr-2001
# Changes   : Added verbose switch to control output when running from cron
#             (quiet) and interactively (shows output).
#
# Calls     : None
# Called by : maint

############################################################
# Initialize
############################################################
import os, sys, maintlib;

# General
params = maintlib.getparams (sys.argv[0:]);
progname = params[0];
maintlog = params[1];
verbose = params[2];

ignore = [ maintlog, verbose ];

# Handle no params
if ( len(params) < 2 ):
        print "Usage: " + os.path.basename (progname) + " logfile [selections]";
        print "       selections may be:";
        print "         all OR [ports source system downloads music]";
        sys.exit (1);

# Strip maintlog and verbose code from params.
for p in ignore:
	params.remove (p);

backupdir = "/backup/";
tarext = ".tar.gz";

if ( verbose == "yes" ):
	taropt = " -zxvf";
else:
	taropt = " -zxf ";

tarcmd = "tar " + taropt + backupdir;

musicfname = "music" + tarext;

portsfname = "ports" + tarext;

sourcefname1 = "source1" + tarext;
sourcefname2 = "source2" + tarext;

sysfname1 = "system1" + tarext;
sysfname2 = "system2" + tarext;
sysfname3 = "system3" + tarext;
sysfname4 = "system4" + tarext;

dlname1 = "download1" + tarext;
dlname2 = "download2" + tarext;
dlname3 = "download3" + tarext;
dlname4 = "download4" + tarext;

log = open (maintlog, "a");
maintlib.writelog (log, "");
maintlib.writelog (log, "Starting Build(s)");

#############################################################
# Do the work..
#############################################################

if ( params[0] == "all" ):
	params = [ "ports", "source", "system", "downloads", "music" ];

os.chdir ("/");
	
for sel in params:
	maintlib.writelog (log, "");
	maintlib.writelog (log, "Restoring " + sel);

	if ( sel == "ports" ):
		cmd = tarcmd + portsfname;
		os.system (cmd);
	elif ( sel == "source" ):
		for p in range(2):
			cmd = tarcmd + "sourcefname" + str(p);
			os.system (cmd);
	elif ( sel == "system" ):
		for p in range(4):
			cmd = tarcmd + "sysfname" + str(p);
			os.system (cmd);
	elif ( sel == "downloads" ):
		for p in range(3):
			cmd = tarcmd + "dlfname" + str(p) + tarext;
			os.system (cmd);
	elif ( sel == "music" ):
		cmd = tarcmd + "music" + tarext;
		os.system (cmd);

	# End elif

	maintlib.writelog (log,  "Finished restoring " + sel);

log.close;

sys.exit (0);
