#! /usr/bin/env python
#
# Copyright (c) 2001
#            Dale A. Weber, Oregon  97217.  
#        All rights reserved.
#    
#    Redistribution and use in source and binary forms, with or without
#    modification, are permitted provided that the following conditions
#    are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer as
#       the first lines of this file unmodified.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    
#    THIS SOFTWARE IS PROVIDED BY %%your_name_here%% ``AS IS'' AND ANY EXPRESS OR
#    IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
#    OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#    IN NO EVENT SHALL %%your_name_here%% BE LIABLE FOR ANY DIRECT, INDIRECT,
#    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#    NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#              
#            $Id: maint-update.py,v 1.6 2001/04/29 18:35:01 kermutt Exp $
#
# System maintenance update script for FreeBSD 4.2 or later.
#
# Author    : Dale Weber <software@dynaplex.net>
# Version   : 0.5.0
# Language  : Python 2.0
# Date      : 21-Apr-2001
# Changes   : Original Release
#
# Version   : 0.5.2
# Date      : 29-Apr-2001
# Changes   : Added verbose switch to control output when running from cron
#           :   (quiet) or interactively (shows output)
#
# Calls     : maint-build-kde2, maint-build-system, and maint-build-system2
# Called by : maint

############################################################
# Initialize
############################################################
import os, sys, maintlib;

# General
params = maintlib.getparams (sys.argv[0:]);

progname = params[0];
maintlog = params[1];
maintconfdir = params[2];
verbose = params[3];

if (verbose == "yes" ):
	cvsupcmd = "cvsup -g -L 2";
else:
	cvsupcmd = "cvsup -g -L 0";

supfiles = maintconfdir + "/supfiles";

# Handle no params
if ( len(params) < 2 ):
        print "Usage: " + os.path.basename (progname) + " logfile confdir [selections]";
        print "       selections may be:";
        print "         all OR [ports source kde2]";
        sys,exit (1);

# End if

ignore = [ progname,  maintlog, maintconfdir, verbose ];

# Strip progname, logfile, and confdir from params
for p in ignore:
	params.remove(p);

log = open (maintlog, "a");

maintlib.writelog (log, "");
maintlib.writelog (log, "Starting Update(s)");

#############################################################
# Do the work..
#############################################################

if ( params[0] == "all" ):
	params = [ "ports", " source" ];

os.chdir (supfiles);

for sel in params:
	if os.path.exists (sel):
		maintlib.writelog (log, "");
		maintlib.writelog (log, "Updating " + sel);
		cmd = cvsupcmd + " " + sel;
		os.system (cmd);

		maintlib.writelog (log, "Finished updating " + sel);
	else:
		print "ERROR: Supfile " + sel + " not found, can't update!";
		maintlib.writelog (log, "ERROR: Supfile " + sel + " not found, can't update!");
		sys.exit (2);

sys.exit (0);
