# System maintenance common library
#
# Copyright (c) 2001
#            Dale A. Weber, Oregon  97217.  
#        All rights reserved.
#    
#    Redistribution and use in source and binary forms, with or without
#    modification, are permitted provided that the following conditions
#    are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer as
#       the first lines of this file unmodified.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    
#    THIS SOFTWARE IS PROVIDED BY %%your_name_here%% ``AS IS'' AND ANY EXPRESS OR
#    IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
#    OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#    IN NO EVENT SHALL %%your_name_here%% BE LIABLE FOR ANY DIRECT, INDIRECT,
#    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
#    NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
#    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#              
#            $Id: maintlib.py,v 1.8 2001/04/29 18:35:01 kermutt Exp $
#
# Author    : Dale Weber <software@dynaplex.net>
# Version   : 0.5.0
# Language  : Python 2.0
# Date      : 21-Apr-2001
# Changes   : Original Release
#
# Version   : 0.5.2
# Date      : 29-Apr-2001
# Changes   : Added ".py" and ".csh extensions to all scripts
#           : Added error checking for commands.
#
import os, string, time;

#
# Setup the log file
#
def init (logfile):
	log = open (logfile, "w");
	writelog (log, "Starting System Maintenance");

	log.close;

# End init

#
# Write message to a log file
#
def writelog (log, str):
	log.write (logstamp() + ": " + str + "\n");

# End writelog

#
# Get parameters from command line and make sure they are
#   all loser case
#
def getparams (args):
	params = args;

	for p in range (len(params)):
        	params[p] = string.lower (params[p]);

	return params;

# End getparams

#
# Return a datestamp for log entries
#
def datestamp (delimiter):
	curtimesecs = time.time();
	curdate = time.localtime(curtimesecs);

	curyear = str (curdate[0]);
	curmonth = string.zfill (str(curdate[1]), 2);
	curday = string.zfill (str(curdate[2]), 2);

	return curmonth + delimiter + curday + delimiter + curyear;

# End datestamp

#
# Return a timestamp for log entries
#
def timestamp ():
	curtimesecs = time.time();
	curdate = time.localtime(curtimesecs);

        curhour = string.zfill (str(curdate[3]), 2);
        curmins = string.zfill (str(curdate[4]), 2);
        cursecs = string.zfill (str(curdate[5]), 2);

        return curhour + ":" + curmins + ":" + cursecs;

# End timestamp

#
# Return a filedate stamp for a filename
#
def filedate ():
	curtimesecs = time.time();
	curdate = time.localtime(curtimesecs);

	curyear = str (curdate[0]);
	curmonth = string.zfill (str(curdate[1]), 2);
	curday = string.zfill (str(curdate[2]), 2);

	return curyear + "-" + curmonth + "-" + curday;

# End filedate

#
# Return a full log entry date/time stamp
#
def logstamp ():
	return datestamp ("/") + " " + timestamp ();

# End logstamp

#
# Create a command line to be excuted by os.system ()
#
def newcmd (log, progname, params, operation, maintlog, maintconfdir, maintdatadir, verbose):
	#
	# Check the operation to make sure it's valid
	#

	checkval = checkoper(log, progname, operation);

	if ( checkval >0 ):
		return "ERROR"; 

	#
	# Build single command to proccess
	#
	plist = range(len(params));

	cmd = "maint-" + operation + ".py" + " " + maintlog;

	#
	# Special command processing
	#
	if ( operation == "build" or operation == "clean" ):
		cmd = cmd + " " + maintdatadir;
	elif  ( operation == "backup" or operation == "update" ):
		cmd = cmd + " " + maintconfdir;
	
	cmd = cmd + " " + verbose

	#
	# Add paraneters to command
	#
	for p in plist:
		cmd = cmd + " " + params[p];

	return cmd;

# End newcmd

#
# Check the opeartion for validity, pring and log error message if
#   invalid.
#
def checkoper (log, progname, operation):
	#
	# Check the operation to make sure it's valid
	#
	legal = [ "backup", "build", "clean", "restore", "update",
                  "daily",  "weekly", "monthly", "yearly", "special" ];

	if ( not operation in legal ):
		errtxt =  "ERROR - (" + os.path.basename(progname) + ") Invalid operation: " + operation + "!";
		print errtxt;
		writelog (log, errtxt);
		return 1;
	else:
		return 0;

# End check 
