#ifndef _MIME_H_
#define _MIME_H_

struct mime_header;
struct mime_message;

/* mime_header routines */
const char *mime_getvalue(struct mime_header *, const char *);
const char *mime_getvaluec(struct mime_header *, const char *, int *);
/* general mime parser routines */
struct mime_header *mime_parseheader(char *, int, char **, const char *);
void mime_headerdelete(struct mime_header *);

/* mime_message */
struct mime_message *mime_readmessage(char *, int, const char *);
struct mime_message **mime_parsemultipart(char *, int, const char *, int *, char **, const char *);
struct mime_header *mime_getmsgheaders(struct mime_message *);
char *mime_getmsgbody(struct mime_message *);
int mime_getmsgbodylen(struct mime_message *);
struct mime_message *mime_getattachment(struct mime_message *, int);
int mime_nattachment(struct mime_message *);
char *mime_getmsgprolog(struct mime_message *);
int mime_getmsgprologlen(struct mime_message *);
char *mime_getmsgepilog(struct mime_message *);
int mime_getmsgepiloglen(struct mime_message *);

int mime_estimaterawsize(struct mime_message *);
int mime_getrawbody(struct mime_message *, char *, int);

#endif /* _MIME_H_ */
