// EmailAddressList.cpp

#include "EmailAddressList.h"

using namespace std;


EmailAddressList::EmailAddressList()
{
}


EmailAddressList::EmailAddressList(const EmailAddressList& aList)
{
    _CopyAddresses(aList);
}


EmailAddressList::~EmailAddressList()
{
    _DeleteAddresses();
}


EmailAddressList& EmailAddressList::operator = (const EmailAddressList& aList)
{
    if (this != &aList) {
        _DeleteAddresses();
        _CopyAddresses(aList);
    }
    return *this;
}


void EmailAddressList::Add(const EmailAddress& aAddr)
{
    EmailAddress* addr = new EmailAddress(aAddr);
	mAddresses.push_back(addr);
}


int EmailAddressList::Count() const
{
    return mAddresses.size();
}


const EmailAddress& EmailAddressList::Get(int aIndex) const
{
    return *mAddresses[aIndex];
}


void EmailAddressList::_DeleteAddresses()
{
    vector<EmailAddress*>::iterator ppaddr;
    for (ppaddr = mAddresses.begin(); ppaddr != mAddresses.end(); ++ppaddr) {
        if (*ppaddr) delete *ppaddr;
        *ppaddr = 0;
    }
    mAddresses.clear();
}


void EmailAddressList::_CopyAddresses(const EmailAddressList& aList)
{
    vector<EmailAddress*>::iterator ppaddr;
    for (ppaddr = mAddresses.begin(); ppaddr != mAddresses.end(); ++ppaddr) {
        EmailAddress* addr = new EmailAddress(**ppaddr);
        mAddresses.push_back(addr);
    }
}
