// create_ex.cpp
//
// This example program creates an email message by setting the originator,
// the recipients, the date, the subject, the memo text, and an attachment.
// Use this program to experiment: try different attachments, recipients,
// etc.  Output goes to standard out.
//

#include <time.h>
#include <iostream.h>
#include <mimepp/mimepp.h>
#include "EmailMessage.h"

using namespace std;


int main()
{
    // Create a new message

    EmailMessage msg;

    // Set the originator ("From")

    EmailAddress originator("doug@example.com", "Doug Sauder", "US-ASCII");
    msg.Originator(originator);

    // Set first recipient ("To")

    EmailAddress to1("jblow@example.com", "Joe Blow", "US-ASCII");
    msg.ToRecipients().Add(to1);

    // Set second recipient ("Cc")

    EmailAddress to2("schmuergen@example.com", "J\374rgen Schm\374rgen",
        "ISO-8859-1");
    msg.CcRecipients().Add(to2);

    // Set subject

    string subjectStr = "This is a test. Viel Spa\337";
    EmailText subject(subjectStr, "ISO-8859-1");
    msg.Subject(subject);

    // Set memo text (the primary text of the message)

    string memoStr = "Just another test.  Sch\336nen Tag!";
    EmailText memo(memoStr, "ISO-8859-1");
    msg.MemoText(memo);

    // Add an attachment

    DwString data = "123456";
    EmailAttachment attach;
    attach.MediaType("application", "octet-stream");
    attach.FileName("groo.dat");
    attach.Content(data);
    msg.Attachments().Add(attach);

    // Serialize the message

    DwString msgStr;
    msg.SerializeTo(msgStr);

	std::cout << msgStr << endl;

    return 0;
}
