// smtp_ex.cpp

#include <iostream.h>
#include <fstream.h>
#include <mimepp/mimepp.h>
#include "smtp.h"


class MySmtpErrorHandler : public SmtpErrorHandler {
public:
    virtual DwBool Error(
        DwMessage& aMessage,
        const char* aServer,
        const char* aSender,
        const char* aRecipient,
        int aErrorCode,
        const char* aErrorMessage);
};


DwBool MySmtpErrorHandler::Error(
    DwMessage& aMessage,
    const char* aServer,
    const char* aSender,
    const char* aRecipient,
    int aErrorCode,
    const char* aErrorMessage)
{
    cout << aErrorMessage << endl;
    return DwTrue;
}



int main(int argc, char** argv)
{
    MySmtpErrorHandler errorHandler;
    Smtp smtp("smtp.xyz.com", 0, 0);
    smtp.SetErrorHandler(&errorHandler);
    smtp.SendMessageFile("test.txt");
    return 0;
}

