// smtp.h
//
// The Smtp class declared in this file and defined in smtp.cpp is a nice
// wrapper class around the MIME++ DwSmtpClient class.  DwSmtpClient
// operates at a fairly low level -- you have to control every part of the
// dialog with the SMTP server.  In contrast, this Smtp class is a fairly
// high-level class -- it manages to entire SMTP dialog.  It also provides
// some nice convenience features:
//
//    * It can optionally get the originator and recipients from the
//      message headers
//
//    * If the originator and recipient are obtained from the message
//      headers, then it will also remove the Bcc line from the message
//      before sending it
//
//    * It provides an interface for reporting errors
//

#ifndef SMTP_H
#define SMTP_H


// Note: It might be a better idea to have a collaborator class that receives
// both negative and positive feedback.  In other words, it would receive
// notifications of errors, but also notifications of messages send
// successfully

class SmtpErrorHandler {
public:
    virtual DwBool Error(
        DwMessage& aMessage,
        const char* aServer,
        const char* aSender,
        const char* aRecipient,
        int aErrorCode,
        const char* aErrorMessage) = 0;
};


class Smtp {

private:

    const char* mServer;
    const char* mSender;
    const char* mRecipient;
    SmtpErrorHandler* mErrorHandler;

public:

    Smtp();
    Smtp(const char* aServer, const char* aSender, const char* aRecipient);

    void SetServer(const char* aServer);
    const char* Server();

    void SetSender(const char* aSender);
    const char* Sender();

    void SetRecipient(const char* aRecipient);
    const char* Recipient();

    void SetErrorHandler(SmtpErrorHandler* aHandler);

    int SendMessageObject(DwMessage& aMessage);

    int SendMessageFile(const char* aFilename);

    int SendMessageBuffer(const DwString& aMessageStr);

};

#endif
