
#include <mingpp.h>

SWFFont *f;
SWFMovie *m;

class spinner
{
  SWFDisplayItem *i;
  int x;
  int y;
  double rot;
  double scale;

 public:

  // functions with huge numbers of arbitrary
  // arguments are always a good idea!  Really!

  spinner(int r, int g, int b, int a, float rot,
	  int x, int y, float scale, char *string)
  {
    SWFText *t = new SWFText();
    t->setFont(f);
    t->setColor(r, g, b, a);
    t->setHeight(960);
    t->moveTo(-(t->getWidth(string))/2, 220);
    t->addString(string);

    // we can add properties just like a normal php var,
    // as long as the names aren't already used.
    // e.g., we can't set i->scale, because that's a function

    this->x = x;
    this->y = y;
    this->rot = rot;
    this->scale = scale;

    i = m->add(t);
    i->rotateTo(rot);
    i->scaleTo(scale);
  }

  void step()
  {
    rot = 19*rot/20;
    x = (19*x + 1200)/20;
    y = (19*y + 800)/20;
    scale = (19*scale + 1.0)/20;

    i->rotateTo(rot);
    i->scaleTo(scale);
    i->moveTo(x, y);
  }
};

int main()
{
  Ming_init();
  Ming_setScale(1.0);

  char *string = "ming!";

  f = new SWFFont("../common/test.fdb");

  m = new SWFMovie();
  m->setRate(24.0);
  m->setDimension(2400, 1600);
  m->setBackground(0xff, 0xff, 0xff);

  // see?  it sure paid off in legibility:

  spinner *i1, *i2, *i3;

  i1 = new spinner(0xff, 0x33, 0x33, 0xff, 900, 1200, 800, 0.03, string);
  i2 = new spinner(0x00, 0x33, 0xff, 0x7f, -560, 1200, 800, 0.04, string);
  i3 = new spinner(0xff, 0xff, 0xff, 0x9f, 180, 1200, 800, 0.001, string);

  for(int i=1; i<=100; ++i)
  {
    i1->step();
    i2->step();
    i3->step();

    m->nextFrame();
  }

  m->save("test.swf");

  exit(0);
}
