
#include <mingpp.h>

int main()
{
  Ming_init();
  Ming_setScale(1.0);

  SWFMovie *m = new SWFMovie();
  m->setRate(36.0);
  m->setDimension(1200, 800);
  m->setBackground(0, 0, 0);

  /* mouse tracking sprite - empty, but follows mouse so we can
     get its x and y coordinates */

  SWFDisplayItem *i = m->add(new SWFSprite());
  i->setName("mouse");

  m->add(new SWFAction("
    startDrag('/mouse', 1); /* '1' means lock sprite to the mouse */
  "));


  /* might as well turn off antialiasing, since these are just squares. */

  m->add(new SWFAction("
    this.quality = 0;
  "));

  /* morphing box */
  SWFMorph *r = new SWFMorph();
  SWFShape *s;

  s = r->getShape1();

  s->setLeftFill(s->addSolidFill(0xff, 0xff, 0xff));
  s->movePenTo(-40, -40);
  s->drawLine(80, 0);
  s->drawLine(0, 80);
  s->drawLine(-80, 0);
  s->drawLine(0, -80);

  s = r->getShape2();

  s->setLeftFill(s->addSolidFill(0x00, 0x00, 0x00));
  s->movePenTo(-1, -1);
  s->drawLine(2, 0);
  s->drawLine(0, 2);
  s->drawLine(-2, 0);
  s->drawLine(0, -2);


  /* sprite container for morphing box -
     this is just a timeline w/ the box morphing */

  SWFSprite *box = new SWFSprite();
  box->add(new SWFAction("
    stop();
  "));
  i = box->add(r);

  for(int n=0; n<=20; ++n)
  {
    i->setRatio(n/20.0);
    box->nextFrame();
  }


  /* this container sprite allows us to use the same action code many times */

  SWFSprite *cell = new SWFSprite();
  i = cell->add(box);
  i->setName("box");

  cell->add(new SWFAction("

    setTarget('box');

    /* ...x means the x coordinate of the parent, i.e. (..).x */
    dx = (/mouse.x + random(6)-3 - ...x)/5;
    dy = (/mouse.y + random(6)-3 - ...y)/5;
    gotoFrame(int(dx*dx + dy*dy));

  "));

  cell->nextFrame();
  cell->add(new SWFAction("

    gotoFrame(0);
    play();

  "));

  cell->nextFrame();


  /* finally, add a bunch of the cells to the movie */

  for(int x=0; x<12; ++x)
  {
    for(int y=0; y<8; ++y)
    {
      SWFDisplayItem *i = m->add(cell);
      i->moveTo(100*x+50, 100*y+50);
    }
  }

  m->nextFrame();

  m->add(new SWFAction("

    gotoFrame(1);
    play();

  "));

  m->save("test.swf");

  exit(0);
}
