# GnomeMenu.py
#
# Moleskine: a source code editor for the GNOME desktop
#
# Copyright (c) 2000 - 2002   Michele Campeotto <micampe@micampe.it>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

from gnome.ui import *
import GDK

import menu

file_menu = [
    UIINFO_MENU_NEW_ITEM(_('_New'), _('Create a new file'), menu.new_document),
    UIINFO_MENU_OPEN_ITEM(menu.open_document),
    UIINFO_SUBTREE_STOCK(menu.MENU_OPEN_PREVIOUS, [], STOCK_MENU_BOOK_OPEN),
    UIINFO_SEPARATOR,
    UIINFO_MENU_SAVE_ITEM(menu.save_document),
    UIINFO_MENU_SAVE_AS_ITEM(menu.save_as_document),
    UIINFO_ITEM_STOCK(_('Save all'), None, menu.save_all, STOCK_MENU_SAVE),
    UIINFO_MENU_REVERT_ITEM(menu.revert_document),
    UIINFO_SEPARATOR,
    (APP_UI_ITEM, _('Load session...'), _('Load session from a file'),
     menu.load_session, None, APP_PIXMAP_STOCK, STOCK_MENU_TIMER, GDK.F11, 0),
    (APP_UI_ITEM, _('Save session...'), _('Save current session to a file'),
     menu.save_session, None, APP_PIXMAP_STOCK, STOCK_MENU_TIMER_STOP, GDK.F12, 0),
    UIINFO_SUBTREE_STOCK(MENU_RECENT_SESSIONS, [], STOCK_MENU_BOOK_OPEN),
    UIINFO_SEPARATOR,
    (APP_UI_ITEM, _('Next'), None, menu.file_next, None,
     APP_PIXMAP_STOCK, STOCK_MENU_FORWARD, GDK.period, GDK.CONTROL_MASK),
    (APP_UI_ITEM, _('Previous'), None, menu.file_previous, None,
     APP_PIXMAP_STOCK, STOCK_MENU_BACK, GDK.comma, GDK.CONTROL_MASK),
    (APP_UI_ITEM, _('Last used'), None, menu.file_last_used, None,
     APP_PIXMAP_NONE, None, GDK.P, GDK.CONTROL_MASK),
    UIINFO_SEPARATOR,
    UIINFO_MENU_CLOSE_ITEM(menu.close_document),
    (APP_UI_ITEM, _('Close all'), None, menu.close_all, None,
     APP_PIXMAP_STOCK, STOCK_MENU_CLOSE,
     GDK.w, GDK.CONTROL_MASK + GDK.SHIFT_MASK),
    UIINFO_MENU_EXIT_ITEM(menu.exit)
]

edit_menu = [
    UIINFO_MENU_UNDO_ITEM(menu.undo),
    UIINFO_MENU_REDO_ITEM(menu.redo),
    UIINFO_MENU_CUT_ITEM(menu.cut),
    UIINFO_MENU_COPY_ITEM(menu.copy),
    UIINFO_MENU_PASTE_ITEM(menu.paste),
    UIINFO_SEPARATOR,
    UIINFO_MENU_FIND_ITEM(menu.search),
    (APP_UI_ITEM, _('Search in _files...'), _('Search a string in multiple files'),
     menu.search_in_files, None, APP_PIXMAP_STOCK, STOCK_MENU_SEARCH,
     GDK.F9, 0),
    UIINFO_MENU_FIND_AGAIN_ITEM(menu.search_next),
    (APP_UI_ITEM, _('Search _Previous'), _('Search the previous occurrence of the last searched string'),
     menu.search_previous, None, APP_PIXMAP_STOCK, STOCK_MENU_SEARCH,
     GDK.F6, GDK.CONTROL_MASK + GDK.SHIFT_MASK),
#    UIINFO_SEPARATOR,
    UIINFO_MENU_REPLACE_ITEM(menu.replace),
#    (APP_UI_ITEM, _('Replace Next'),
#     _('Find and replace next string in current file'),
#     menu.replace_next, None, APP_PIXMAP_STOCK, STOCK_MENU_SRCHRPL,
#     GDK.F7, GDK.CONTROL_MASK),
    UIINFO_SEPARATOR,
    (APP_UI_ITEM, _('_Goto line...'), _('Go to specified line in current file'),
     menu.goto_line, None, APP_PIXMAP_STOCK, STOCK_MENU_JUMP_TO,
     GDK.l, GDK.CONTROL_MASK + GDK.MOD1_MASK),
]

settings_menu = [
    UIINFO_MENU_PREFERENCES_ITEM(menu.options),
    UIINFO_SEPARATOR,
    UIINFO_ITEM_STOCK(_('Languages _settings...'), None,
                      menu.lang_settings, STOCK_MENU_PROP),
    UIINFO_SUBTREE_STOCK(menu.MENU_CHANGE_LANGUAGE, [], STOCK_MENU_JUMP_TO),
    UIINFO_SEPARATOR,
    (APP_UI_TOGGLEITEM, _('Show _white space'), None, menu.toggle_ws, None,
     APP_PIXMAP_NONE, None, 0, 0),
    (APP_UI_TOGGLEITEM, _('Show _end of line'), None, menu.toggle_eol, None,
     APP_PIXMAP_NONE, None, 0, 0),
]

tools_menu = [
    (APP_UI_ITEM, _('_Next bookmark'), None, menu.next_bookmark, None,
     APP_PIXMAP_STOCK, STOCK_MENU_FORWARD, GDK.F2, 0),
    (APP_UI_ITEM, _('_Previous bookmark'), None, menu.prev_bookmark, None,
     APP_PIXMAP_STOCK, STOCK_MENU_BACK, GDK.F2, GDK.SHIFT_MASK),
    (APP_UI_ITEM, _('_Toggle bookmark'), None, menu.toggle_bookmark, None,
     APP_PIXMAP_STOCK, STOCK_MENU_BOOK_YELLOW, GDK.F2, GDK.CONTROL_MASK),
    UIINFO_ITEM_STOCK(_('_Clear bookmarks'), None,
                      menu.clear_bookmarks, STOCK_MENU_TRASH_FULL),
    UIINFO_SEPARATOR,
    (APP_UI_ITEM, _('_Complete word'), None,
     menu.complete_word, None, APP_PIXMAP_STOCK, STOCK_MENU_JUMP_TO,
     GDK.space, GDK.CONTROL_MASK),
    UIINFO_SUBTREE(_('Convert _EOLs'), [
        UIINFO_ITEM(_('LF (_Unix)'), None, menu.eol_to_lf),
        UIINFO_ITEM(_('CR (_Mac)'), None, menu.eol_to_cr),
        UIINFO_ITEM(_('CR+LF (Dos/_Win)'), None, menu.eol_to_crlf)]),
    UIINFO_SEPARATOR,
    UIINFO_SUBTREE(_('CVS'), [
        UIINFO_ITEM(_('Commit file to CVS'), None, menu.cvs_commit),
        UIINFO_ITEM(_('Update file from CVS'), None, menu.cvs_update),
        UIINFO_ITEM(_('CVS diff file'), None, menu.cvs_diff),
        UIINFO_ITEM(_('File\'s CVS status'), None, menu.cvs_status),
        UIINFO_ITEM(_('File\'s CVS log'), None, menu.cvs_log),
        UIINFO_ITEM(_('Add file to CVS'), None, menu.cvs_add),
        UIINFO_ITEM(_('Remove file from CVS'), None, menu.cvs_remove),
        UIINFO_SEPARATOR,
        UIINFO_ITEM(_('Commit directory to CVS'), None, menu.cvs_commit_dir),
        UIINFO_ITEM(_('Update directory from CVS'), None, menu.cvs_update_dir),
        UIINFO_ITEM(_('CVS diff directory'), None, menu.cvs_diff_dir),
        UIINFO_ITEM(_('Directory\'s CVS status'), None, menu.cvs_status_dir),
        UIINFO_ITEM(_('Directory\'s CVS log'), None, menu.cvs_log_dir),
        UIINFO_ITEM(_('Add directory to CVS'), None, menu.cvs_add_dir)#,
        #UIINFO_ITEM(_('Remove directory from CVS'), None, menu.cvs_directory)
        ]),
    UIINFO_SEPARATOR,
    (APP_UI_ITEM, _('Clean-up recent files list'), None, menu.clean_up_mru, None,
     APP_PIXMAP_NONE, None, 0, 0),
    (APP_UI_ITEM, _('Delete recent files list'), None, menu.delete_mru, None,
     APP_PIXMAP_NONE, None, 0, 0),
]

help_menu = [
#    UIINFO_MENU_ABOUT_ITEM(menu.about)
    UIINFO_ITEM_STOCK(_('Moleskine info'), None, menu.about, STOCK_MENU_ABOUT)
]

main_menu = [
    UIINFO_SUBTREE(menu.MENU_FILE, file_menu),
    UIINFO_SUBTREE(_('_Edit'), edit_menu),
    UIINFO_SUBTREE(menu.MENU_SETTINGS, settings_menu),
    UIINFO_SUBTREE(_('_Tools'), tools_menu),
    UIINFO_SUBTREE(_('_Help'), help_menu)
]
