# toolbar.py
#
# Moleskine: a source code editor for the GNOME desktop
#
# Copyright (c) 2000 - 2002  Michele Campeotto <micampe@micampe.it>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

from gnome.ui import *

import menu

main_toolbar = [
    UIINFO_ITEM_STOCK(_('New'), _('Create a new file'),
            menu.new_document, STOCK_PIXMAP_NEW),
    UIINFO_ITEM_STOCK(_('Open'), _('Load a file from disk'),
            menu.open_document, STOCK_PIXMAP_OPEN),
    UIINFO_ITEM_STOCK(_('Save'), _('Save current file to disk'),
            menu.save_document, STOCK_PIXMAP_SAVE),
    UIINFO_ITEM_STOCK(_('Close'), _('Close current file'),
            menu.close_document, STOCK_PIXMAP_CLOSE),
    UIINFO_SEPARATOR,
    UIINFO_ITEM_STOCK(_('Undo'), _('Undo last action'),
            menu.undo, STOCK_PIXMAP_UNDO),
    UIINFO_ITEM_STOCK(_('Redo'), _('Redo last action'),
            menu.redo, STOCK_PIXMAP_REDO),
    UIINFO_SEPARATOR,
    UIINFO_ITEM_STOCK(_('Cut'), _('Cut selected text to the clipboard'),
            menu.cut, STOCK_PIXMAP_CUT),
    UIINFO_ITEM_STOCK(_('Copy'), _('Copy selected text to the clipboard'),
            menu.copy, STOCK_PIXMAP_COPY),
    UIINFO_ITEM_STOCK(_('Paste'), _('Paste text from the clipboard'),
            menu.paste, STOCK_PIXMAP_PASTE),
    UIINFO_SEPARATOR,
    UIINFO_ITEM_STOCK(_('Search'), _('Search a string in current file'),
            menu.search, STOCK_PIXMAP_SEARCH),
    UIINFO_ITEM_STOCK(_('Replace'), _('Search and replace a string'),
            menu.replace, STOCK_PIXMAP_SRCHRPL),
    UIINFO_SEPARATOR,
    UIINFO_ITEM_STOCK(_('Quit'), _('Quit Moleskine'),
            menu.exit, STOCK_PIXMAP_EXIT)
]
