/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.EOFException;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import org.gjt.mm.mysql.Buffer;
import org.gjt.mm.mysql.DatabaseMetaData;
import org.gjt.mm.mysql.Driver;
import org.gjt.mm.mysql.MysqlIO;
import org.gjt.mm.mysql.PreparedStatement;
import org.gjt.mm.mysql.ResultSet;
import org.gjt.mm.mysql.Statement;

public class Connection
implements java.sql.Connection {
    MysqlIO _IO;
    private boolean _isClosed = true;
    private String _Host;
    private int _port = 3306;
    private String _User;
    private String _Password;
    private String _Database;
    private boolean _autoCommit = true;
    private boolean _readOnly = false;
    private boolean _do_unicode = false;
    private String _Encoding;
    private String _MyURL;
    private int _max_rows = -1;
    private boolean _max_rows_changed = false;
    private Driver _MyDriver;
    private boolean _high_availability = false;
    private int _max_reconnects = 3;
    private double _initial_timeout = 2.0;
    private static final String _PING_COMMAND = "SELECT 1";

    public Connection(String Host, int port, Properties Info, String Database, String Url, Driver D) throws SQLException {
        int n;
        this._Host = Host == null ? "localhost" : new String(Host);
        this._port = port;
        if (Database == null) {
            throw new SQLException("Malformed URL '" + Url + "'.", "S1000");
        }
        this._Database = new String(Database);
        this._MyURL = new String(Url);
        this._MyDriver = D;
        String U = Info.getProperty("user");
        String P = Info.getProperty("password");
        this._User = U == null || U.equals("") ? "nobody" : new String(U);
        this._Password = P == null ? "" : new String(P);
        if (Info.getProperty("autoReconnect") != null) {
            this._high_availability = Info.getProperty("autoReconnect").toUpperCase().equals("TRUE");
        }
        if (this._high_availability) {
            if (Info.getProperty("maxReconnects") != null) {
                try {
                    this._max_reconnects = n = Integer.parseInt(Info.getProperty("maxReconnects"));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Illegal parameter '" + Info.getProperty("maxReconnects") + "' for maxReconnects", "0S100");
                }
            }
            if (Info.getProperty("initialTimeout") != null) {
                try {
                    double n2;
                    this._initial_timeout = n2 = (double)Integer.parseInt(Info.getProperty("intialTimeout"));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Illegal parameter '" + Info.getProperty("initialTimeout") + "' for initialTimeout", "0S100");
                }
            }
        }
        if (Info.getProperty("maxRows") != null) {
            try {
                n = Integer.parseInt(Info.getProperty("maxRows"));
                if (n == 0) {
                    n = -1;
                }
                this._max_rows = n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Illegal parameter '" + Info.getProperty("maxRows") + "' for maxRows", "0S100");
            }
        }
        if (Info.getProperty("useUnicode") != null) {
            String UseUnicode = Info.getProperty("useUnicode").toUpperCase();
            if (UseUnicode.startsWith("TRUE")) {
                this._do_unicode = true;
            }
            if (Info.getProperty("characterEncoding") != null) {
                this._Encoding = Info.getProperty("characterEncoding");
                try {
                    String TestString = "abc";
                    TestString.getBytes(this._Encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException("Unsupported character encoding '" + this._Encoding + "'.", "0S100");
                }
            }
        }
        try {
            this._IO = new MysqlIO(Host, port);
            this._IO.init(this._User, this._Password);
            this._IO.sendCommand(2, this._Database, null);
            this._isClosed = false;
        }
        catch (SQLException E) {
            throw E;
        }
        catch (Exception E) {
            E.printStackTrace();
            throw new SQLException("Cannot connect to MySQL server on " + this._Host + ":" + this._port + ". Is there a MySQL server running on the machine/port you are trying to connect to? (" + E.getClass().getName() + ")", "08S01");
        }
    }

    public java.sql.Statement createStatement() throws SQLException {
        Statement Stmt = new Statement(this, this._Database);
        if (this._max_rows != -1) {
            Stmt.setMaxRows(this._max_rows);
        }
        return Stmt;
    }

    public java.sql.PreparedStatement prepareStatement(String Sql) throws SQLException {
        PreparedStatement PStmt = new PreparedStatement(this, Sql, this._Database);
        return PStmt;
    }

    public CallableStatement prepareCall(String Sql) throws SQLException {
        throw new SQLException("Callable statments not suppoted.", "S1C00");
    }

    public String nativeSQL(String Sql) throws SQLException {
        return Sql;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (!autoCommit) {
            throw new SQLException("Cannot disable AUTO_COMMIT", "08003");
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this._autoCommit;
    }

    public void commit() throws SQLException {
    }

    public void rollback() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Rollback attempt on closed connection.", "08003");
        }
    }

    public void close() throws SQLException {
        if (this._IO != null) {
            try {
                this._IO.quit();
            }
            catch (Exception exception) {}
            this._IO = null;
        }
        this._isClosed = true;
    }

    public boolean isClosed() throws SQLException {
        block5: {
            if (this._isClosed) break block5;
            try {
                MysqlIO mysqlIO = this._IO;
                synchronized (mysqlIO) {
                    this.execSQL(_PING_COMMAND, -1);
                }
            }
            catch (Exception exception) {
                this._isClosed = true;
            }
        }
        return this._isClosed;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData DBMD = new DatabaseMetaData(this, this._Database);
        return DBMD;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this._readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this._readOnly;
    }

    public void setCatalog(String Catalog) throws SQLException {
        this.execSQL("USE " + Catalog, -1);
        this._Database = Catalog;
    }

    public String getCatalog() throws SQLException {
        return this._Database;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        throw new SQLException("Transaction Isolation Levels are not supported.", "S1C00");
    }

    public int getTransactionIsolation() throws SQLException {
        return 8;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    ResultSet execSQL(String Sql, int max_rows) throws SQLException {
        return this.execSQL(Sql, max_rows, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ResultSet execSQL(String Sql, int max_rows, Buffer Packet) throws SQLException {
        MysqlIO mysqlIO = this._IO;
        synchronized (mysqlIO) {
            block15: {
                if (this._high_availability) {
                    int i;
                    boolean connection_good;
                    double timeout;
                    try {
                        this._IO.sqlQuery(_PING_COMMAND, 50000000);
                        break block15;
                    }
                    catch (Exception exception) {
                        timeout = this._initial_timeout;
                        connection_good = false;
                        i = 0;
                    }
                    while (i < this._max_reconnects) {
                        try {
                            this._IO = new MysqlIO(this._Host, this._port);
                            this._IO.init(this._User, this._Password);
                            this._IO.sendCommand(2, this._Database, null);
                            this._IO.sqlQuery(_PING_COMMAND, 50000000);
                            connection_good = true;
                            break;
                        }
                        catch (Exception exception) {
                            try {
                                Thread.currentThread();
                                Thread.sleep((long)timeout * 1000L);
                                timeout *= timeout;
                            }
                            catch (InterruptedException interruptedException) {}
                            ++i;
                        }
                    }
                    if (!connection_good) {
                        throw new SQLException("Server connection failure during transaction. \nAttemtped reconnect " + this._max_reconnects + " times. Giving up.", "08001");
                    }
                }
            }
            try {
                int real_max_rows = max_rows == -1 ? 50000000 : max_rows;
                if (Packet != null) return this._IO.sqlQueryDirect(Packet, real_max_rows);
                String Encoding = null;
                if (!this.useUnicode()) return this._IO.sqlQuery(Sql, real_max_rows, Encoding);
                Encoding = this.getEncoding();
                return this._IO.sqlQuery(Sql, real_max_rows, Encoding);
            }
            catch (EOFException eOFException) {
                throw new SQLException("Lost connection to server during query", "08007");
            }
            catch (Exception E) {
                String ExceptionType = E.getClass().getName();
                String ExceptionMessage = E.getMessage();
                throw new SQLException("Error during query: Unexpected Exception: " + ExceptionType + " message given: " + ExceptionMessage, "S1000");
            }
        }
    }

    String getURL() {
        return this._MyURL;
    }

    String getUser() {
        return this._User;
    }

    String getServerVersion() {
        return this._IO.getServerVersion();
    }

    int getServerMajorVersion() {
        return this._IO.getServerMajorVersion();
    }

    int getServerMinorVersion() {
        return this._IO.getServerMinorVersion();
    }

    int getServerSubMinorVersion() {
        return this._IO.getServerSubMinorVersion();
    }

    void maxRowsChanged() {
        this._max_rows_changed = true;
    }

    boolean useMaxRows() {
        return this._max_rows_changed;
    }

    boolean useUnicode() {
        return this._do_unicode;
    }

    String getEncoding() {
        return this._Encoding;
    }

    Object getMutex() {
        return this._IO;
    }
}

