/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import org.gjt.mm.mysql.MysqlDefs;

class Field {
    int length;
    String Name;
    String TableName;
    int sql_type = -1;
    int mysql_type = -1;
    short colFlag;
    int colDecimals;

    Field(String Table, String Name, int length, int mysql_type, short col_flag, int col_decimals) {
        this.TableName = new String(Table);
        this.Name = new String(Name);
        this.length = length;
        this.colFlag = col_flag;
        this.colDecimals = col_decimals;
        this.mysql_type = mysql_type;
        this.sql_type = MysqlDefs.mysqlToJavaType(mysql_type);
    }

    public Field(String Table, String Name, int jdbc_type, int length) {
        this.TableName = new String(Table);
        this.Name = new String(Name);
        this.length = length;
        this.sql_type = jdbc_type;
        this.colFlag = 0;
        this.colDecimals = 0;
    }

    String getTable() {
        if (this.TableName != null) {
            return new String(this.TableName);
        }
        return null;
    }

    String getName() {
        if (this.Name != null) {
            return new String(this.Name);
        }
        return null;
    }

    String getFullName() {
        String FullName = String.valueOf(this.TableName) + "." + this.Name;
        return FullName;
    }

    String getTableName() {
        return this.TableName;
    }

    int getLength() {
        return this.length;
    }

    int getSQLType() {
        return this.sql_type;
    }

    int getMysqlType() {
        return this.mysql_type;
    }

    int getDecimals() {
        return this.colDecimals;
    }

    boolean isNotNull() {
        return (this.colFlag & 1) > 0;
    }

    boolean isPrimaryKey() {
        return (this.colFlag & 2) > 0;
    }

    boolean isUniqueKey() {
        return (this.colFlag & 4) > 0;
    }

    boolean isMultipleKey() {
        return (this.colFlag & 8) > 0;
    }

    boolean isBlob() {
        return (this.colFlag & 0x10) > 0;
    }

    boolean isUnsigned() {
        return (this.colFlag & 0x20) > 0;
    }

    boolean isZeroFill() {
        return (this.colFlag & 0x40) > 0;
    }

    public boolean isBinary() {
        return (this.colFlag & 0x80) > 0;
    }

    public String toString() {
        return this.getFullName();
    }
}

