/*
 * #Id: ngrep.h,v 1.10 2001/12/31 22:02:00 jpr5 Exp #
 *
 * $Id: ngrep-lib.h,v 1.6 2002/01/02 03:52:32 mavetju Exp $
 *
 * Copyright (c) 2001  Jordan Ritter <jpr5@darkridge.com>
 *
 * Modifications for ngrep-lib by Edwin Groothuis <edwin@mavetju.org>
 *
 * Please refer to the COPYRIGHT.ngrep file for more information. 
 *
 */

#define VERSION "1.40.1"


#define ETHHDR_SIZE 14 
#define TOKENRING_SIZE 22
#define PPPHDR_SIZE 4 
#define SLIPHDR_SIZE 16
#define RAWHDR_SIZE 0
#define LOOPHDR_SIZE 4 
#define FDDIHDR_SIZE 21
#define ISDNHDR_SIZE 21

#ifndef IP_OFFMASK
#define IP_OFFMASK 0x1fff
#endif

#define WORD_REGEX "((^%s\\W)|(\\W%s$)|(\\W%s\\W))"
#define IP_ONLY "ip and ( %s)"

void ngrep_main(char *bpffilter,char *matchexpression,char *options);
void ngrep_callback_arp(void *arp);
void ngrep_callback_ip(void *ip);
void ngrep_callback_tcp(void *tcp);
void ngrep_callback_udp(void *udp);
void ngrep_callback_icmp(void *icmp);
void ngrep_callback_process(void *ip,void *tcp,void *udp,void *icmp);
void ngrep_callback_info(void *info,void *stats);
void ngrep_setfilter(char *bpffilter,char *matchexpression,char *options);
void ngrep_run(void);

char *get_filter(char **);
void process(u_char *, struct pcap_pkthdr*, u_char *);
void dump(char *, int); 
void clean_exit(int);
void ngrep_usage(int);
void version(void);

int re_match_func(char *, int); 
int bin_match_func(char *, int);
int blank_match_func(char *, int); 

int strishex(char *);

void print_time_absolute(struct pcap_pkthdr *);
void print_time_diff_init(struct pcap_pkthdr *);
void print_time_diff(struct pcap_pkthdr *);

void dump_delay_proc_init(struct pcap_pkthdr *);
void dump_delay_proc(struct pcap_pkthdr *);

void update_windowsize(int);
