/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import org.hsql.Channel;
import org.hsql.Database;
import org.hsql.Result;
import org.hsql.Server;

class ServerConnection
extends Thread {
    private Database mDatabase;
    private Socket mSocket;
    private DataInputStream mInput;
    private DataOutputStream mOutput;

    private Channel init() {
        try {
            this.mSocket.setTcpNoDelay(true);
            this.mInput = new DataInputStream(new BufferedInputStream(this.mSocket.getInputStream()));
            this.mOutput = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            String string = this.mInput.readUTF();
            String string2 = this.mInput.readUTF();
            try {
                return this.mDatabase.connect(string, string2);
            }
            catch (SQLException sQLException) {
                this.write(new Result(sQLException.getMessage()).getBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void run() {
        Channel channel = this.init();
        if (channel != null) {
            try {
                String string;
                while ((string = this.mInput.readUTF()) != null) {
                    this.write(this.mDatabase.execute(string, channel).getBytes());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.mSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.mDatabase.isShutdown()) {
            System.out.println("The database is shutdown");
            System.exit(0);
        }
    }

    void write(byte[] byArray) throws IOException {
        this.mOutput.writeInt(byArray.length);
        this.mOutput.write(byArray);
        this.mOutput.flush();
    }

    ServerConnection(Socket socket, Server server) {
        this.mSocket = socket;
        this.mDatabase = server.mDatabase;
    }
}

