/*
 * Decompiled with CFR 0.152.
 */
package com.evermind;

import com.evermind._cp;
import com.evermind._cv;
import com.evermind._dfb;
import com.evermind._gs;
import com.evermind._pe;
import com.evermind._sz;
import com.evermind.security.User;
import com.evermind.server.ApplicationServer;
import com.evermind.server.http.ClusteredHttpSession;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.util.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class _cy
extends _sz {
    public static final boolean _gy = _pe._di("http.cluster.debug", false);
    public static final byte[] _jsb = new byte[]{4, 78, 2, 6, 1, 10, 98, -34};
    public _cp _fd;
    protected boolean _jtb;
    protected boolean _jub;
    protected long _jvb;
    protected List _jwb;
    protected long _ap;
    protected boolean _jxb;

    public void _wrb(EvermindHttpSession evermindHttpSession) {
        if (_gy) {
            System.out.println("Sending HTTP-cluster session creation for session " + evermindHttpSession.getId() + "...");
        }
        try {
            Message message = this._gt._leb().createMessage();
            message.setByteProperty("command", (byte)2);
            _cy._xcb(message, "session", evermindHttpSession.id);
            message.setLongProperty("creationTime", evermindHttpSession.creationTime);
            if (this._fd._jyb != 0) {
                message.setIntProperty("ip", evermindHttpSession.ip);
            }
            this._qz(message);
        }
        catch (JMSException jMSException) {
            this._fd.log("Error registering session with the cluster", jMSException);
        }
    }

    public void _wsb() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this._fd._xfb(byteArrayOutputStream);
            BytesMessage bytesMessage = this._gt._leb().createBytesMessage();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            bytesMessage.writeInt(byArray.length);
            if (_gy) {
                _cy._wtb("Sending " + byArray.length + " long response");
            }
            if (_gy) {
                _cy._wtb("Sent raw data: " + new String(byArray));
            }
            bytesMessage.writeBytes(byArray);
            bytesMessage.setByteProperty("command", (byte)7);
            this._qz(bytesMessage);
            if (_gy) {
                _cy._wtb("Sent sessions");
            }
        }
        catch (Exception exception) {
            this._fd.log("Error while sending sessions to the cluster", exception);
        }
    }

    public static final void _wtb(String string) {
    }

    protected _cy(String string, _cp _cp2, long l) throws JMSException, IOException, UnknownHostException {
        super(string);
        this._fd = _cp2;
        this._ap = l;
        if (_gy) {
            System.out.println("HTTP-clustering service started...");
        }
    }

    public void _wub(ByteString byteString, String string, Object object) {
        byte[] byArray = null;
        if (_gy) {
            System.out.println("Sending HTTP-cluster session value update for session " + byteString + ": " + string + "=" + object + "...");
        }
        try {
            BytesMessage bytesMessage = this._gt._leb().createBytesMessage();
            if (object != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    _dfb _dfb2 = new _dfb(byteArrayOutputStream);
                    ApplicationServer._txb(_dfb2, object);
                    _dfb2.close();
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    this._fd.log("Error serializing session object", exception);
                    return;
                }
            }
            bytesMessage.setByteProperty("command", (byte)3);
            _cy._xcb(bytesMessage, "session", byteString);
            bytesMessage.setStringProperty("name", string);
            if (byArray != null) {
                bytesMessage.writeInt(byArray.length);
            } else {
                bytesMessage.writeInt(0);
            }
            bytesMessage.writeBytes(_jsb);
            if (byArray != null) {
                bytesMessage.writeBytes(byArray);
            }
            this._qz(bytesMessage);
        }
        catch (JMSException jMSException) {
            this._fd.log("Error updating session value in the cluster", jMSException);
        }
    }

    public void _wvb(BytesMessage bytesMessage) {
        try {
            byte[] byArray = new byte[bytesMessage.readInt()];
            if (_gy) {
                _cy._wtb("Receiving " + byArray.length + " long response");
            }
            bytesMessage.readBytes(byArray);
            if (_gy) {
                _cy._wtb("Received raw data: " + new String(byArray));
            }
            this._fd._xgb(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            this._fd.log("Error while receiving sessions from the cluster", exception);
        }
    }

    public void _wwb(Message message) throws JMSException {
        switch (message.getByteProperty("command")) {
            case 1: {
                if (_gy) {
                    System.out.println("Receiving HTTP-cluster session invalidation for session " + message.getStringProperty("session") + "...");
                }
                this._fd._yr.remove(message.getStringProperty("session"));
                break;
            }
            case 13: {
                if (!_gy) break;
                System.out.println("Receving keep-alive heartbeat from " + message.getStringProperty("siteName") + ": " + Integer.toHexString(message.getIntProperty("address")) + ":" + message.getIntProperty("port"));
                break;
            }
            case 11: {
                if (_gy) {
                    System.out.println("Receiving HTTP-cluster send-sessions request...");
                }
                try {
                    Message message2 = this._gt._leb().createMessage();
                    message2.setByteProperty("command", (byte)10);
                    message2.setStringProperty("id", String.valueOf(this._ap));
                    this._qz(message2);
                    if (!_gy) break;
                    _cy._wtb("Sent 'yes, I can provide sessions' response");
                }
                catch (JMSException jMSException) {
                    this._fd.log("Error sending session-approval response", jMSException);
                }
                break;
            }
            case 12: {
                try {
                    if (_gy) {
                        System.out.println("Receiving HTTP-cluster send-sessions permission from " + message.getLongProperty("id") + " (I'm " + this._ap + ")...");
                    }
                    if (message.getLongProperty("id") != this._ap) break;
                    this._wsb();
                }
                catch (JMSException jMSException) {
                    this._fd.log("Error sending application state", jMSException);
                }
                break;
            }
            case 3: {
                if (_gy) {
                    System.out.println("Receiving HTTP-cluster session value update...");
                }
                BytesMessage bytesMessage = (BytesMessage)message;
                ByteString byteString = _cy._xdb(message, "session");
                EvermindHttpSession evermindHttpSession = this._fd._xhb(byteString);
                int n = bytesMessage.readInt();
                if (n != 0) {
                    byte[] byArray = new byte[n + _jsb.length];
                    bytesMessage.readBytes(byArray, n + _jsb.length);
                    if (evermindHttpSession == null) break;
                    evermindHttpSession._trb(message.getStringProperty("name"), byArray);
                    break;
                }
                evermindHttpSession._tmb(message.getStringProperty("name"));
                break;
            }
            case 6: {
                EvermindHttpSession evermindHttpSession = this._fd._xhb(_cy._xdb(message, "session"));
                int n = message.getIntProperty("timeout");
                if (evermindHttpSession == null) break;
                evermindHttpSession.maxInactiveInterval = n;
                break;
            }
            case 4: {
                Serializable serializable = ((ObjectMessage)message).getObject();
                if (serializable != null) {
                    this._fd._xib(message.getStringProperty("name"), serializable);
                    break;
                }
                this._fd._xjb(message.getStringProperty("name"));
                break;
            }
            case 2: {
                ByteString byteString = _cy._xdb(message, "session");
                ClusteredHttpSession clusteredHttpSession = new ClusteredHttpSession(this, this._fd, byteString, byteString._nv(), this._fd._jzb);
                clusteredHttpSession.lastAccessedTime = clusteredHttpSession.creationTime = message.getLongProperty("creationTime");
                if (this._fd._jyb != 0) {
                    clusteredHttpSession.ip = message.getIntProperty("ip");
                }
                Map map = this._fd._yr;
                synchronized (map) {
                    this._fd._yr.put(byteString, clusteredHttpSession);
                    Object var8_23 = null;
                }
                if (!_gy) break;
                _cy._wtb("Registered remote session");
                break;
            }
            case 5: {
                long l;
                ByteString byteString = _cy._xdb(message, "session");
                ClusteredHttpSession clusteredHttpSession = (ClusteredHttpSession)this._fd._xhb(byteString);
                if (clusteredHttpSession == null || clusteredHttpSession.lastAccessedTime == (l = message.getLongProperty("time"))) break;
                if (clusteredHttpSession.lastAccessedTime > l) {
                    this._wxb(byteString, clusteredHttpSession.lastAccessedTime);
                    break;
                }
                clusteredHttpSession.lastAccessedTime = l;
                clusteredHttpSession.warned = false;
                break;
            }
            case 14: {
                ByteString byteString = _cy._xdb(message, "session");
                String string = message.getStringProperty("user");
                ClusteredHttpSession clusteredHttpSession = (ClusteredHttpSession)this._fd._xhb(byteString);
                if (clusteredHttpSession != null) {
                    User user = string == null ? null : this._fd._cd()._jrb().getUser(string);
                    clusteredHttpSession._xkb(user);
                }
                if (!_gy) break;
                _cy._wtb("Changed user due to cluster note for session " + byteString + " to " + (string == null ? "none" : string));
                break;
            }
        }
    }

    public void _wxb(ByteString byteString, long l) {
        try {
            Message message = this._gt._leb().createMessage();
            _cy._xcb(message, "session", byteString);
            message.setByteProperty("command", (byte)5);
            message.setLongProperty("time", l);
        }
        catch (JMSException jMSException) {
            this._fd.log("Error while sending session last updated to the cluster", jMSException);
        }
    }

    public void _wyb(ByteString byteString, String string) {
        Object var3_3 = null;
        if (_gy) {
            System.out.println("Sending session-owner update for session " + byteString + ": " + string + "...");
        }
        try {
            Message message = this._gt._leb().createMessage();
            message.setByteProperty("command", (byte)14);
            if (string != null) {
                message.setStringProperty("user", string);
            }
            _cy._xcb(message, "session", byteString);
            this._qz(message);
        }
        catch (JMSException jMSException) {
            this._fd.log("Error updating session user in the cluster", jMSException);
        }
    }

    public void _wzb(ByteString byteString, String string) {
        try {
            ObjectMessage objectMessage = this._gt._leb().createObjectMessage();
            objectMessage.setByteProperty("command", (byte)8);
            _cy._xcb(objectMessage, "session", byteString);
            objectMessage.setStringProperty("name", string);
            this._qz(objectMessage);
        }
        catch (JMSException jMSException) {
            this._fd.log("Error updating RMI session value in the cluster", jMSException);
        }
    }

    public void _xab(String string, Serializable serializable) {
        if (_gy) {
            System.out.println("Sending HTTP-cluster context value update: " + string + "=" + serializable + "...");
        }
        try {
            ObjectMessage objectMessage = this._gt._leb().createObjectMessage();
            objectMessage.setByteProperty("command", (byte)4);
            objectMessage.setStringProperty("name", string);
            objectMessage.setObject(serializable);
            this._qz(objectMessage);
        }
        catch (JMSException jMSException) {
            this._fd.log("Error updating context value in the cluster", jMSException);
        }
    }

    public void _xbb(ByteString byteString, int n) {
        try {
            Message message = this._gt._leb().createMessage();
            _cy._xcb(message, "session", byteString);
            message.setByteProperty("command", (byte)6);
            message.setIntProperty("timeout", n);
        }
        catch (JMSException jMSException) {
            this._fd.log("Error while sending session last updated to the cluster", jMSException);
        }
    }

    public static final void _xcb(Message message, String string, ByteString byteString) throws JMSException {
        if (message instanceof _gs) {
            ((_gs)message)._xcb(string, byteString);
        } else {
            message.setStringProperty(string, byteString.toString());
        }
    }

    public static final ByteString _xdb(Message message, String string) throws JMSException {
        if (message instanceof _gs) {
            return ((_gs)message)._xdb(string);
        }
        return new ByteString(message.getStringProperty(string));
    }

    public void _xeb(String string) {
        try {
            ObjectMessage objectMessage = this._gt._leb().createObjectMessage();
            objectMessage.setByteProperty("command", (byte)8);
            objectMessage.setStringProperty("name", string);
            this._qz(objectMessage);
        }
        catch (JMSException jMSException) {
            this._fd.log("Error updating RMI session value in the cluster", jMSException);
        }
    }

    public void _er(_cv _cv2) {
        if (_gy) {
            System.out.println("HTTP-Clustering service initializing...");
        }
        super._er(_cv2);
        this._jvb = System.currentTimeMillis();
        this._jtb = true;
        this._jub = false;
        this._jwb = new ArrayList();
        try {
            Message message = _cv2._leb().createMessage();
            message.setByteProperty("command", (byte)11);
            this._qz(message);
            if (_gy) {
                System.out.println("HTTP-Clustering sent \"I want sessions\" request...");
            }
        }
        catch (JMSException jMSException) {
            System.err.println("Error starting HTTP-cluster: " + jMSException.getMessage());
        }
    }

    public void _gg(Message message) {
        try {
            if (_gy) {
                _cy._wtb("Received: " + message);
            }
            if (this._jtb) {
                if (System.currentTimeMillis() < this._jvb + 4000L) {
                    byte by = message.getByteProperty("command");
                    if (by == 10) {
                        if (_gy) {
                            System.out.println("Receiving HTTP-cluster send-sessions goahead from " + message.getStringProperty("id") + "...");
                        }
                        if (!this._jub) {
                            this._jub = true;
                            Message message2 = this._gt._leb().createMessage();
                            message2.setByteProperty("command", (byte)12);
                            message2.setStringProperty("id", message.getStringProperty("id"));
                            this._qz(message2);
                            if (_gy) {
                                _cy._wtb("Sent 'Yes, go ahead' response");
                            }
                        }
                    } else if (by == 7) {
                        if (_gy) {
                            System.out.println("Receiving HTTP-cluster sessions...");
                        }
                        this._wvb((BytesMessage)message);
                    } else {
                        this._jwb.add(message);
                    }
                } else {
                    this._jtb = false;
                    Iterator iterator = this._jwb.iterator();
                    while (iterator.hasNext()) {
                        this._wwb((Message)iterator.next());
                    }
                    this._wwb(message);
                }
            } else {
                this._wwb(message);
            }
        }
        catch (JMSException jMSException) {
            this._fd.log("Error while listening to the cluster", jMSException);
        }
    }
}

