/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.ejb;

import com.evermind.ejb.EJBUser;
import com.evermind.ejb.EJBUserManager;
import com.evermind.security.Group;
import com.evermind.security.User;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class EJBUserWrapper
implements User {
    public EJBUserManager _lyb;
    public String _dg;
    public EJBUser _fvb;

    public String getDescription() {
        try {
            return this._fvb.getDescription();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public void setDescription(String string) {
        try {
            this._fvb.setDescription(string);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public boolean hasPermission(Permission permission) {
        Group group;
        Set set = this._lyb.getDefaultGroups();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            group = (Group)iterator.next();
            if (!group.hasPermission(permission)) continue;
            return true;
        }
        try {
            if (this._fvb.hasPermission(permission)) {
                return true;
            }
            set = this._fvb.getGroups();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                group = this._lyb.getGroup(iterator.next().toString());
                if (group == null || !group.hasPermission(permission)) continue;
                return true;
            }
            return false;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public EJBUserWrapper(EJBUserManager eJBUserManager, String string, EJBUser eJBUser) {
        this._lyb = eJBUserManager;
        this._dg = string;
        this._fvb = eJBUser;
    }

    public Locale getLocale() {
        try {
            return this._fvb.getLocale();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public void setLocale(Locale locale) {
        try {
            this._fvb.setLocale(locale);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public void setPassword(String string) {
        try {
            this._fvb.setPassword(string);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public String getPassword() {
        try {
            return this._fvb.getPassword();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public String getCertificateIssuerDN() {
        try {
            return this._fvb.getCertificateIssuerDN();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public void addToGroup(Group group) {
        if (this._lyb.getDefaultGroups() != null && this._lyb.getDefaultGroups().contains(group)) {
            return;
        }
        try {
            this._fvb.addToGroup(group.getName());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public void setCertificate(String string, BigInteger bigInteger) {
        try {
            this._fvb.setCertificate(string, bigInteger);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public void setCertificate(X509Certificate x509Certificate) {
        try {
            this._fvb.setCertificate(x509Certificate);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public BigInteger getCertificateSerial() {
        try {
            return this._fvb.getCertificateSerial();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public String getName() {
        if (this._dg == null) {
            try {
                this._dg = this._fvb.getDescription();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("RemoteException: " + remoteException.getMessage());
            }
        }
        return this._dg;
    }

    public boolean isMemberOf(Group group) {
        if (this._lyb.getDefaultGroups().contains(group)) {
            return true;
        }
        try {
            Set set = this._fvb.getGroups();
            return set != null && set.contains(group.getName());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public void removeFromGroup(Group group) {
        try {
            this._fvb.removeFromGroup(group.getName());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public boolean authenticate(String string) {
        try {
            return this._fvb.authenticate(string);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }

    public Set getGroups() {
        HashSet<Group> hashSet = new HashSet<Group>();
        try {
            Set set = this._fvb.getGroups();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof String) {
                        Group group = this._lyb.getGroup((String)e);
                        if (group == null) continue;
                        hashSet.add(group);
                        continue;
                    }
                    if (e == null) {
                        throw new NullPointerException("EJB groups set contained null instance");
                    }
                    hashSet.add((Group)e);
                }
            }
            return hashSet;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("RemoteException: " + remoteException.getMessage());
        }
    }
}

