/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.gui.server.jms;

import java.text.DateFormat;
import java.util.Date;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.swing.table.AbstractTableModel;

public class QueueContentTableModel
extends AbstractTableModel {
    public Message[] messages = new Message[0];

    public int getRowCount() {
        return this.messages.length;
    }

    public QueueContentTableModel(Message[] messageArray) {
        this.messages = messageArray;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Category";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Content";
            }
            case 3: {
                return "Sent";
            }
        }
        return "";
    }

    public void _lsd(Message[] messageArray) {
        this.messages = messageArray;
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        Message message = this.messages[n];
        if (message == null) {
            return "-";
        }
        try {
            switch (n2) {
                case 0: {
                    if (message instanceof ObjectMessage) {
                        return "Object";
                    }
                    if (message instanceof TextMessage) {
                        return "Text";
                    }
                    if (message instanceof StreamMessage) {
                        return "Stream";
                    }
                    if (message instanceof BytesMessage) {
                        return "Bytes";
                    }
                    if (message instanceof MapMessage) {
                        return "Map";
                    }
                    return "Generic";
                }
                case 1: {
                    return message.getJMSType();
                }
                case 2: {
                    if (message instanceof ObjectMessage) {
                        return String.valueOf(((ObjectMessage)message).getObject());
                    }
                    if (message instanceof TextMessage) {
                        return ((TextMessage)message).getText();
                    }
                    if (message instanceof StreamMessage) {
                        return "...";
                    }
                    if (message instanceof BytesMessage) {
                        return "...";
                    }
                    if (message instanceof MapMessage) {
                        return "...";
                    }
                    return "...";
                }
                case 3: {
                    return DateFormat.getDateTimeInstance().format(new Date(message.getJMSTimestamp()));
                }
            }
            return "";
        }
        catch (JMSException jMSException) {
            return "...";
        }
    }
}

