/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.file;

import com.evermind._vd;
import com.evermind.naming.file.ContentFileContext;
import com.evermind.naming.file.FileContext;
import com.evermind.util.ObjectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class FileNamingEnumeration
implements NamingEnumeration {
    public File[] _gtd;
    public FileContext _gt;
    public int _hp;
    public NameClassPair _po;
    public NamingException _pp;

    public void close() {
    }

    public Object nextElement() {
        if (this._po == null) {
            throw new NoSuchElementException(String.valueOf(this._hp - 1));
        }
        NameClassPair nameClassPair = this._po;
        this._po = this.getNameClassPair();
        return nameClassPair;
    }

    public FileNamingEnumeration(File[] fileArray, FileContext fileContext) {
        this._gtd = fileArray;
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n] == null) {
                throw new NullPointerException("File array entry was null");
            }
            ++n;
        }
        this._gt = fileContext;
        this._po = this.getNameClassPair();
    }

    public NameClassPair getNameClassPair() {
        if (this._gtd == null || this._hp >= this._gtd.length) {
            return null;
        }
        try {
            File file = this._gtd[this._hp++];
            if (file.isDirectory()) {
                return new NameClassPair(file.getName(), "com.evermind.naming.file.FileContext");
            }
            if (this._gt instanceof ContentFileContext) {
                return new NameClassPair(file.getName(), "[B");
            }
            if (this._gt instanceof _vd) {
                FileInputStream fileInputStream = new FileInputStream(file);
                String string = ObjectUtils._oy(fileInputStream, ((_vd)this._gt)._dnc()).getClass().getName();
                fileInputStream.close();
                return new NameClassPair(file.getName(), string);
            }
            return new NameClassPair(file.getName(), "java.io.File");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._pp = new NamingException("ClassNotFoundException: " + classNotFoundException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            this._pp = new NamingException("IO Error: " + iOException.getMessage());
            return null;
        }
    }

    public boolean hasMoreElements() {
        return this._po != null;
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public Object next() throws NamingException {
        if (this._po == null && this._pp != null) {
            throw this._pp;
        }
        NameClassPair nameClassPair = this._po;
        this._po = this.getNameClassPair();
        return nameClassPair;
    }
}

