/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind._of;
import com.evermind.util.AbstractDescribable;
import com.evermind.util.ObjectUtils;
import com.evermind.xml.XMLUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataSourceConfig
extends AbstractDescribable
implements Serializable,
_of,
Cloneable {
    public static final long serialVersionUID = 67564345L;
    public String connectionDriver;
    public String url;
    public String sourceLocation;
    public String xaSourceLocation;
    public String className;
    public String username;
    public String password;
    public String description;
    public boolean isDefault;
    public int maxInactivityTimeout;
    public int loginTimeout = -1;
    public int minConnections;
    public int maxConnections;
    public String schemaPath;
    public String host;
    public int port;
    public String xaLocation;
    public String pooledLocation;
    public String ejbLocation;
    public boolean implicit;
    public long connectionRetryInterval = 1000L;
    public int maxConnectionAttempts = 3;
    public long waitTimeout = 60000L;
    public Properties properties;

    public String _aw() {
        return this.className;
    }

    public void _ao(String string) {
        this.className = string;
    }

    public String _gp() {
        return this._ak();
    }

    public void _ot(String string, String string2) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(string, string2);
    }

    public int _rmd() {
        return this.loginTimeout;
    }

    public String _rgd() {
        return this.sourceLocation;
    }

    public void _rzc(String string) {
        this.sourceLocation = string;
    }

    public void _sfc(int n) {
        this.maxInactivityTimeout = n;
    }

    public int _sec() {
        return this.maxInactivityTimeout;
    }

    public long _sic() {
        return this.connectionRetryInterval;
    }

    public void _sjc(long l) {
        this.connectionRetryInterval = l;
    }

    public String _red() {
        return this.schemaPath;
    }

    public void _spc(boolean bl) {
        this.isDefault = bl;
    }

    public void _sdc(int n) {
        this.maxConnections = n;
    }

    public int _scc() {
        return this.maxConnections;
    }

    public Object clone() {
        try {
            DataSourceConfig dataSourceConfig = (DataSourceConfig)super.clone();
            if (this.properties != null) {
                dataSourceConfig.properties = new Properties();
                ((Hashtable)dataSourceConfig.properties).putAll(this.properties);
            }
            return dataSourceConfig;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void _av(PrintWriter printWriter, String string) {
        printWriter.println(string + "<data-source");
        if (this.className != null) {
            printWriter.println(string + "\tclass=\"" + XMLUtils._ba(this.className) + "\"");
        }
        if (this._cf() != null) {
            printWriter.println(string + "\tname=\"" + XMLUtils._ba(this._cf()) + "\"");
        }
        if (this._gp() != null) {
            printWriter.println(string + "\tlocation=\"" + XMLUtils._ba(this._gp()) + "\"");
        }
        if (this._smc() != null) {
            printWriter.println(string + "\tpooled-location=\"" + XMLUtils._ba(this._smc()) + "\"");
        }
        if (this._ryc() != null) {
            printWriter.println(string + "\txa-location=\"" + XMLUtils._ba(this._ryc()) + "\"");
        }
        if (this._snc() != null) {
            printWriter.println(string + "\tejb-location=\"" + XMLUtils._ba(this._snc()) + "\"");
        }
        if (this.sourceLocation != null) {
            printWriter.println(string + "\tsource-location=\"" + XMLUtils._ba(this.sourceLocation) + "\"");
        }
        if (this.xaSourceLocation != null) {
            printWriter.println(string + "\txa-source-location=\"" + XMLUtils._ba(this.xaSourceLocation) + "\"");
        }
        if (this.connectionDriver != null) {
            printWriter.println(string + "\tconnection-driver=\"" + XMLUtils._ba(this.connectionDriver) + "\"");
        }
        if (this.username != null) {
            printWriter.println(string + "\tusername=\"" + XMLUtils._ba(this.username) + "\"");
        }
        if (this.password != null) {
            printWriter.println(string + "\tpassword=\"" + XMLUtils._ba(this.password) + "\"");
        }
        if (this.url != null) {
            printWriter.println(string + "\turl=\"" + XMLUtils._ba(this.url) + "\"");
        }
        if (this.minConnections > 0) {
            printWriter.println(string + "\tmin-connections=\"" + this.minConnections + "\"");
        }
        if (this.maxConnections > 0) {
            printWriter.println(string + "\tmax-connections=\"" + this.maxConnections + "\"");
        }
        if (this.waitTimeout != 60000L) {
            printWriter.println(string + "\twait-timeout=\"" + this.waitTimeout / 1000L + "\"");
        }
        if (this._sec() > 0) {
            printWriter.println(string + "\tinactivity-timeout=\"" + this._sec() + "\"");
        }
        if (this.maxConnectionAttempts != 3) {
            printWriter.println(string + "\tmax-connection-attempts=\"" + this.maxConnectionAttempts + "\"");
        }
        if (this.connectionRetryInterval != 1000L) {
            if (this.connectionRetryInterval % 1000L == 0L) {
                printWriter.println(string + "\tconnection-retry-interval=\"" + this.connectionRetryInterval / 1000L + "\"");
            } else {
                printWriter.println(string + "\tconnection-retry-interval=\"" + (double)this.connectionRetryInterval / 1000.0 + "\"");
            }
        }
        if (this.description != null) {
            printWriter.println(string + ">");
            printWriter.println(string + "\t<description>" + XMLUtils._ba(this.description) + "</description>");
            printWriter.println(string + "</data-source>");
        } else {
            printWriter.println(string + "/>");
        }
    }

    public int _fx() {
        return this.port;
    }

    public String _bb() {
        return this.description;
    }

    public void _ay(String string) {
        this.description = string;
    }

    public String _smc() {
        return this.pooledLocation;
    }

    public String _snc() {
        return this.ejbLocation;
    }

    public void _sqc(String string) {
        this.xaSourceLocation = string;
    }

    public String _rfd() {
        return this.xaSourceLocation;
    }

    public Map _ymd() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this._ak() != null) {
            hashMap.put("location", this._ak());
        }
        if (this._cf() != null) {
            hashMap.put("displayName", this._cf());
        }
        if (this._bb() != null) {
            hashMap.put("description", this._bb());
        }
        hashMap.put("connectionDriver", this.connectionDriver);
        hashMap.put("url", this.url);
        hashMap.put("sourceLocation", this.sourceLocation);
        hashMap.put("xaSourceLocation", this.xaSourceLocation);
        hashMap.put("className", this.className);
        hashMap.put("username", this.username);
        hashMap.put("password", this.password);
        hashMap.put("description", this.description);
        hashMap.put("default", this.isDefault ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put("maxInactivityTimeout", ObjectUtils._pb(this.maxInactivityTimeout));
        hashMap.put("loginTimeout", ObjectUtils._pb(this.loginTimeout));
        hashMap.put("maxInactivityTimeout", ObjectUtils._pb(this.maxInactivityTimeout));
        hashMap.put("loginTimeout", ObjectUtils._pb(this.loginTimeout));
        hashMap.put("minConnections", ObjectUtils._pb(this.minConnections));
        hashMap.put("maxConnections", ObjectUtils._pb(this.maxConnections));
        hashMap.put("schemaPath", this.schemaPath);
        hashMap.put("host", this.host);
        hashMap.put("port", ObjectUtils._pb(this.port));
        hashMap.put("xaLocation", this.xaLocation);
        hashMap.put("pooledLocation", this.pooledLocation);
        hashMap.put("ejbLocation", this.ejbLocation);
        hashMap.put("implicit", this.implicit ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put("connectionRetryInterval", new Long(this.connectionRetryInterval));
        hashMap.put("maxConnectionAttempts", ObjectUtils._pb(this.maxConnectionAttempts));
        hashMap.put("waitTimeout", new Long(this.waitTimeout));
        hashMap.put("properties", this.properties);
        return hashMap;
    }

    public DataSourceConfig(Map map) {
        this._ax((String)map.get("location"));
        this._co((String)map.get("displayName"));
        this._ay((String)map.get("description"));
        this.connectionDriver = (String)map.get("connectionDriver");
        this.url = (String)map.get("url");
        this.sourceLocation = (String)map.get("sourceLocation");
        this.xaSourceLocation = (String)map.get("xaSourceLocation");
        this.className = (String)map.get("className");
        this.username = (String)map.get("username");
        this.password = (String)map.get("password");
        this.description = (String)map.get("description");
        this.isDefault = Boolean.TRUE.equals(map.get("default"));
        this.loginTimeout = ObjectUtils._oa(map.get("loginTimeout"), this.maxInactivityTimeout);
        this.minConnections = ObjectUtils._oa(map.get("minConnections"), this.maxInactivityTimeout);
        this.maxConnections = ObjectUtils._oa(map.get("maxConnections"), this.maxInactivityTimeout);
        this.host = (String)map.get("host");
        this.port = ObjectUtils._oa(map.get("port"), this.port);
        this.schemaPath = (String)map.get("schemaPath");
        this.xaLocation = (String)map.get("xaLocation");
        this.pooledLocation = (String)map.get("pooledLocation");
        this.ejbLocation = (String)map.get("ejbLocation");
        this.implicit = Boolean.TRUE.equals(map.get("implicit"));
        this.connectionRetryInterval = ObjectUtils._ov(map.get("connectionRetryInterval"), this.connectionRetryInterval);
        this.maxConnectionAttempts = ObjectUtils._oa(map.get("maxConnectionAttempts"), this.maxConnectionAttempts);
        this.waitTimeout = ObjectUtils._ov(map.get("waitTimeout"), this.waitTimeout);
        this.properties = (Properties)map.get("properties");
    }

    public DataSourceConfig(boolean bl) {
        this.implicit = bl;
    }

    public DataSourceConfig(Node node) throws InstantiationException {
        String string = XMLUtils._mw(node, "class");
        if (string == null) {
            throw new InstantiationException("No 'class' attribute specified for <data-source> tag");
        }
        this._ao(string);
        String string2 = XMLUtils._mw(node, "location");
        if (string2 != null) {
            this._ax(string2);
        }
        this.schemaPath = XMLUtils._mw(node, "schema");
        this.host = XMLUtils._mw(node, "host");
        this.sourceLocation = XMLUtils._mw(node, "source-location");
        this.xaSourceLocation = XMLUtils._mw(node, "xa-source-location");
        this.className = XMLUtils._mw(node, "class");
        this.connectionDriver = XMLUtils._mw(node, "connection-driver");
        this._co(XMLUtils._mw(node, "name"));
        this.username = XMLUtils._mw(node, "username");
        this.password = XMLUtils._mw(node, "password");
        this.url = XMLUtils._mw(node, "url");
        this.xaLocation = XMLUtils._mw(node, "xa-location");
        this.pooledLocation = XMLUtils._mw(node, "pooled-location");
        this.ejbLocation = XMLUtils._mw(node, "ejb-location");
        String string3 = XMLUtils._mw(node, "wait-timeout");
        String string4 = XMLUtils._mw(node, "inactivity-timeout");
        String string5 = XMLUtils._mw(node, "min-connections");
        String string6 = XMLUtils._mw(node, "max-connections");
        String string7 = XMLUtils._mw(node, "login-timeout");
        String string8 = XMLUtils._mw(node, "max-connection-attempts");
        String string9 = XMLUtils._mw(node, "connection-retry-interval");
        if (string3 != null) {
            try {
                this.waitTimeout = Long.parseLong(string3) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                throw new InstantiationException("Bad format for wait-timeout attribute in data-source: " + string3);
            }
        }
        if (string8 != null) {
            try {
                this.maxConnectionAttempts = Integer.parseInt(string8);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string8 != null) {
            try {
                this.connectionRetryInterval = (int)(Double.parseDouble(string9) * 1000.0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string10 = XMLUtils._mw(node, "port");
        if (string4 != null) {
            try {
                this.maxInactivityTimeout = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string10 != null) {
            try {
                this.port = Integer.parseInt(string10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string7 != null) {
            try {
                this.loginTimeout = Integer.parseInt(string7);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string5 != null) {
            try {
                this.minConnections = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string6 != null) {
            try {
                this.maxConnections = Integer.parseInt(string6);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            String string11 = node2.getNodeName();
            if (!string11.equals("#text")) {
                if (string11.equals("source-location")) {
                    this._rzc(XMLUtils.getStringValue(node2));
                } else if (string11.equals("class-name")) {
                    this._ao(XMLUtils.getStringValue(node2));
                } else if (string11.equals("description")) {
                    this._ay(XMLUtils.getStringValue(node2));
                } else if (string11.equals("property")) {
                    String string12 = XMLUtils._mw(node2, "name");
                    String string13 = XMLUtils._mw(node2, "value");
                    if (string12 == null) {
                        throw new InstantiationException("data-source tag with missing name attribute");
                    }
                    if (string13 == null) {
                        throw new InstantiationException("data-source tag with missing value attribute");
                    }
                    this._ot(string12, string13);
                } else if (string11.equals("connection-driver")) {
                    this._eie(XMLUtils.getStringValue(node2));
                } else if (string11.equals("name")) {
                    this._co(XMLUtils.getStringValue(node2));
                } else if (string11.equals("username")) {
                    this._emc(XMLUtils.getStringValue(node2));
                } else if (string11.equals("password")) {
                    this._rkd(XMLUtils.getStringValue(node2));
                } else if (string11.equals("url")) {
                    this._mr(XMLUtils.getStringValue(node2));
                } else if (string11.equals("inactivity-timeout")) {
                    try {
                        this._sfc(Integer.parseInt(XMLUtils.getStringValue(node2)));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string11.equals("max-connections")) {
                    try {
                        this._sdc(Integer.parseInt(XMLUtils.getStringValue(node2)));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string11.equals("url")) {
                    this._mr(XMLUtils.getStringValue(node2));
                } else if (string11.equals("default")) {
                    this._spc(true);
                }
            }
            ++n2;
        }
        if (this.className != null && this.className.equals("com.evermind.sql.ConnectionDataSource")) {
            this.className = "com.evermind.sql.DriverManagerDataSource";
        } else if (this.className != null && this.className.equals("com.evermind.sql.DefaultXADataSource")) {
            this.className = "com.evermind.sql.DriverManagerXADataSource";
        }
    }

    public String _jyd() {
        return this.password;
    }

    public String _rld() {
        return this.connectionDriver;
    }

    public void _eie(String string) {
        this.connectionDriver = string;
    }

    public void _rkd(String string) {
        this.password = string;
    }

    public String _jqb() {
        return this.username;
    }

    public void _emc(String string) {
        this.username = string;
    }

    public String _wd() {
        return this.host;
    }

    public boolean _rxc() {
        return this.implicit;
    }

    public long _skc() {
        return this.waitTimeout;
    }

    public void _slc(long l) {
        this.waitTimeout = l;
    }

    public String _ms() {
        return this.url;
    }

    public void _mr(String string) {
        this.url = string;
    }

    public void _sbc(int n) {
        this.maxConnections = n;
    }

    public int _sac() {
        return this.minConnections;
    }

    public String _ryc() {
        return this.xaLocation;
    }

    public Properties _dqc() {
        return this.properties;
    }

    public int _sgc() {
        return this.maxConnectionAttempts;
    }

    public void _shc(int n) {
        this.maxConnectionAttempts = n;
    }

    public boolean _soc() {
        return this.isDefault;
    }

    public void _gu(String string) {
        this._ax(string);
    }
}

