/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind._gmb;
import com.evermind._gub;
import com.evermind._tb;
import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.AdministrationPermission;
import com.evermind.server.rmi.RMIPermission;
import com.evermind.xml.XMLConfig;
import com.evermind.xml.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUserManager
extends XMLConfig
implements UserManager {
    public UserManager _hy;
    public Map _lwb = new HashMap();
    public Map _lvb = new HashMap();
    public User _qmd;

    public List getUsers(int n, int n2) {
        Map map = this._lvb;
        synchronized (map) {
            ArrayList arrayList = new ArrayList(this._lvb.values());
            Collections.sort(arrayList);
            List list = arrayList.subList(n, n2);
            Object var5_6 = null;
            return list;
        }
    }

    public void _vl(Node node) throws InstantiationException {
        String string = node.getNodeName();
        if (string.equals("users")) {
            this._eqe(node);
        } else if (string.equals("groups")) {
            this._ere(node);
        } else {
            super._vl(node);
        }
    }

    protected void _eoe(Node node) throws InstantiationException {
        _gub _gub2 = new _gub(node, this);
        if (this._lvb.containsKey(_gub2.getName())) {
            throw new InstantiationException("Duplicate user: " + _gub2.getName() + " in " + this._ms());
        }
        this._lvb.put(_gub2.getName(), _gub2);
    }

    protected void _epe(Node node) throws InstantiationException {
        _gmb _gmb2 = new _gmb(XMLUtils._mw(node, "name"));
        if (_gmb2.getName() == null) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if (string.equals("description")) {
                _gmb2.setDescription(XMLUtils.getStringValue(node2));
            } else if (string.equals("permission")) {
                String string2 = XMLUtils._mw(node2, "name");
                if (string2 == null) {
                    string2 = XMLUtils.getStringValue(node2);
                }
                if (string2 != null) {
                    if (string2.equalsIgnoreCase("administration")) {
                        _gmb2.addPermission(AdministrationPermission.INSTANCE);
                    } else if (string2.equalsIgnoreCase("rmi:login")) {
                        _gmb2.addPermission(new RMIPermission("login"));
                    } else {
                        try {
                            Permission permission = (Permission)_tb._pu(string2, this.getClass().getClassLoader());
                            if (permission != null) {
                                _gmb2.addPermission(permission);
                            }
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++n;
        }
        if (this._lwb.containsKey(_gmb2.getName())) {
            throw new InstantiationException("Duplicate group: " + _gmb2.getName() + " in " + this._ms());
        }
        if ("true".equalsIgnoreCase(XMLUtils._mw(node, "default"))) {
            this.addDefaultGroup(_gmb2.getName());
            _gmb2._spc(true);
        }
        this._lwb.put(_gmb2.getName(), _gmb2);
    }

    public User getUser(String string) {
        if (this._lvb != null) {
            Map map = this._lvb;
            synchronized (map) {
                block5: {
                    _gub _gub2 = (_gub)this._lvb.get(string);
                    if (_gub2 == null) break block5;
                    _gub _gub3 = _gub2;
                    Object var4_5 = null;
                    return _gub3;
                }
                Object var4_6 = null;
            }
        }
        if (this._hy != null) {
            return this._hy.getUser(string);
        }
        return null;
    }

    public User getUser(String string, BigInteger bigInteger) {
        if (this._lvb != null) {
            Map map = this._lvb;
            synchronized (map) {
                Iterator iterator = this._lvb.values().iterator();
                while (iterator.hasNext()) {
                    _gub _gub2 = (_gub)iterator.next();
                    BigInteger bigInteger2 = _gub2.getCertificateSerial();
                    if (bigInteger2 == null || !bigInteger2.equals(bigInteger) || !string.equals(_gub2.getCertificateIssuerDN())) continue;
                    _gub _gub3 = _gub2;
                    Object var7_8 = null;
                    return _gub3;
                }
                Object var7_9 = null;
            }
        }
        if (this._hy != null) {
            return this._hy.getUser(string, bigInteger);
        }
        return null;
    }

    public User getUser(X509Certificate x509Certificate) {
        return this.getUser(x509Certificate.getIssuerDN().getName(), x509Certificate.getSerialNumber());
    }

    public void _vm(String string) throws InstantiationException {
        if (!string.equals("principals")) {
            throw new InstantiationException(this._ak() + " contained a " + string + " file, not a principals file as expected");
        }
    }

    public void addDefaultGroup(String string) {
    }

    public User getAnonymousUser() {
        if (this._qmd == null) {
            if (this._hy != null) {
                this._qmd = this._hy.getAnonymousUser();
            } else {
                _gub _gub2 = new _gub(this, "guest");
                _gub2._unc(true);
                this._qmd = _gub2;
                if (this._lvb != null) {
                    this._lvb.put("guest", this._qmd);
                }
            }
        }
        return this._qmd;
    }

    public User createUser(String string, String string2) {
        if (this.getUser(string) != null) {
            throw new IllegalArgumentException("User '" + string + "' already exists");
        }
        _gub _gub2 = new _gub(this, string, string2);
        Map map = this._lvb;
        synchronized (map) {
            this._lvb.put(string, _gub2);
            Object var5_5 = null;
        }
        return _gub2;
    }

    public Group getGroup(String string) {
        if (this._lwb != null) {
            Map map = this._lwb;
            synchronized (map) {
                block5: {
                    Group group = (Group)this._lwb.get(string);
                    if (group == null) break block5;
                    Group group2 = group;
                    Object var4_5 = null;
                    return group2;
                }
                Object var4_6 = null;
            }
        }
        if (this._hy != null) {
            return this._hy.getGroup(string);
        }
        return null;
    }

    public synchronized void _bt(PrintWriter printWriter) throws IOException {
        printWriter.println("<?xml version=\"1.0\"?>");
        printWriter.println("<!DOCTYPE principals PUBLIC \"//Evermind - Orion Principals//\" \"http://www.orionserver.com/dtds/principals.dtd\">");
        printWriter.println();
        this._av(printWriter, "");
    }

    protected void _eqe(Node node) throws InstantiationException {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if (string.equals("user")) {
                this._eoe(node2);
            }
            ++n;
        }
    }

    protected void _ere(Node node) throws InstantiationException {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if (string.equals("group")) {
                this._epe(node2);
            }
            ++n;
        }
    }

    public void _av(PrintWriter printWriter, String string) throws IOException {
        printWriter.println(string + "<principals>");
        printWriter.println(string + "\t<groups>");
        if (this._lwb != null) {
            XMLUtils._bc(this._lwb.values(), printWriter, string + "\t\t");
        }
        printWriter.println(string + "\t</groups>");
        printWriter.println(string + "\t<users>");
        if (this._lvb != null) {
            XMLUtils._bc(this._lvb.values(), printWriter, string + "\t\t");
        }
        printWriter.println(string + "\t</users>");
        printWriter.println(string + "</principals>");
    }

    public boolean remove(Group group) {
        return this._lwb.remove(group.getName()) != null;
    }

    public boolean remove(User user) {
        Map map = this._lvb;
        synchronized (map) {
            this._lvb.remove(user.getName());
            Object var3_3 = null;
        }
        return true;
    }

    public User getAdminUser() {
        if (this._lvb != null) {
            Map map = this._lvb;
            synchronized (map) {
                Iterator iterator = this._lvb.values().iterator();
                while (iterator.hasNext()) {
                    _gub _gub2 = (_gub)iterator.next();
                    if (!_gub2.hasPermission(AdministrationPermission.INSTANCE)) continue;
                    _gub _gub3 = _gub2;
                    Object var4_5 = null;
                    return _gub3;
                }
                Object var4_6 = null;
            }
        }
        return null;
    }

    public Group createGroup(String string) throws InstantiationException {
        Map map = this._lwb;
        synchronized (map) {
            if (this.getGroup(string) != null) {
                throw new IllegalArgumentException("group " + string + " already exists");
            }
            _gmb _gmb2 = new _gmb(string);
            this._lwb.put(string, _gmb2);
            _gmb _gmb3 = _gmb2;
            Object var4_5 = null;
            return _gmb3;
        }
    }

    public int getUserCount() {
        Map map = this._lvb;
        synchronized (map) {
            int n = this._lvb.size();
            Object var2_3 = null;
            return n;
        }
    }

    public int getGroupCount() {
        Map map = this._lwb;
        synchronized (map) {
            int n = this._lwb.size();
            Object var2_3 = null;
            return n;
        }
    }

    public void _adb() {
        this._lwb.clear();
        this._lvb.clear();
    }

    public void setParent(UserManager userManager) {
        this._hy = userManager;
    }

    public UserManager getParent() {
        return this._hy;
    }

    public XMLUserManager() {
        super(null);
    }

    public String _mfb() {
        return "META-INF/principals.dtd";
    }

    public void init(Properties properties) throws InstantiationException {
        String string = properties.getProperty("path");
        if (string == null) {
            throw new InstantiationException("Missing 'path' property, required for XMLUserManager");
        }
        try {
            this._de(new File(string).toURL());
        }
        catch (IOException iOException) {
            throw new InstantiationException("Error reading configuration '" + string + "': " + iOException.getMessage());
        }
    }

    public List getGroups(int n, int n2) {
        Map map = this._lwb;
        synchronized (map) {
            ArrayList arrayList = new ArrayList(this._lwb.values());
            Collections.sort(arrayList);
            List list = arrayList.subList(n, n2);
            Object var5_6 = null;
            return list;
        }
    }

    public Set getDefaultGroups() {
        return Collections.EMPTY_SET;
    }
}

