/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.administration;

import com.evermind._gab;
import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.security.UserAlreadyExistsException;
import com.evermind.security.UserManager;
import com.evermind.server.administration.BasicGroupInfo;
import com.evermind.server.administration.BasicUserInfo;
import com.evermind.server.administration.ExtensiveUserInfo;
import com.evermind.server.administration.UserAdministrator;
import com.evermind.util.ObjectUtils;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultUserAdministrator
implements UserAdministrator {
    public UserManager _lyb;

    public int getUserCount() {
        return this._lyb.getUserCount();
    }

    public int getGroupCount() {
        return this._lyb.getGroupCount();
    }

    public List getUsers(int n, int n2) {
        List list = this._lyb.getUsers(n, n2);
        ArrayList<BasicUserInfo> arrayList = new ArrayList<BasicUserInfo>();
        int n3 = 0;
        while (n3 < list.size()) {
            User user = (User)list.get(n3);
            try {
                arrayList.add(new BasicUserInfo(user.getName(), ObjectUtils._ox(user, "realName", true, true), user.getDescription()));
            }
            catch (IntrospectionException introspectionException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            ++n3;
        }
        return arrayList;
    }

    public DefaultUserAdministrator(UserManager userManager) {
        this._lyb = userManager;
    }

    public void removeGroups(Collection collection) throws IOException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            Group group = this._lyb.getGroup(string);
            if (group == null) continue;
            this._lyb.remove(group);
        }
        this._lyb.store();
    }

    public ExtensiveUserInfo getUser(String string) {
        HashSet hashSet;
        User user = this._lyb.getUser(string);
        if (user == null) {
            return null;
        }
        try {
            hashSet = DefaultUserAdministrator._bce(user.getGroups());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            hashSet = new HashSet();
        }
        String string2 = null;
        try {
            string2 = ObjectUtils._ox(user, "realName", true, true);
        }
        catch (IntrospectionException introspectionException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new ExtensiveUserInfo(user.getName(), string2, user.getDescription(), user.getPassword(), hashSet);
    }

    public void addGroup(BasicGroupInfo basicGroupInfo) throws InstantiationException, IOException, InstantiationException {
        Group group = this._lyb.createGroup(basicGroupInfo._ak());
        group.setDescription(basicGroupInfo._bb());
        int n = 0;
        while (n < basicGroupInfo._fxd().length) {
            String[] stringArray = basicGroupInfo._fxd()[n];
            group.addPermission(new _gab(stringArray[0], stringArray[1], stringArray[2])._rbc(group.getClass().getClassLoader()));
            ++n;
        }
        this._lyb.store();
    }

    public void updateGroup(BasicGroupInfo basicGroupInfo) throws InstantiationException, IOException {
        Group group = this._lyb.getGroup(basicGroupInfo._ak());
        if (group != null && !ObjectUtils._nr(group.getDescription(), basicGroupInfo._bb())) {
            group.setDescription(basicGroupInfo._bb());
        }
        HashSet hashSet = new HashSet(group.getPermissions());
        HashSet hashSet2 = new HashSet(Arrays.asList(basicGroupInfo._fxd()));
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            Permission permission = (Permission)iterator.next();
            int n = 0;
            while (n < basicGroupInfo._fxd().length) {
                if (basicGroupInfo._fxd()[n][0].equals(permission.getClass().getName()) && ObjectUtils._nr(basicGroupInfo._fxd()[n][1], permission.getName()) && ObjectUtils._nr(basicGroupInfo._fxd()[n][2], permission.getActions())) {
                    iterator.remove();
                    hashSet2.remove(basicGroupInfo._fxd()[n]);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) continue;
            group.removePermission(permission);
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            group.addPermission(new _gab(stringArray[0], stringArray[1], stringArray[2])._rbc(group.getClass().getClassLoader()));
        }
        this._lyb.store();
    }

    public void removeUsers(Collection collection) throws IOException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            User user = this._lyb.getUser(string);
            if (user == null) continue;
            this._lyb.remove(user);
        }
        this._lyb.store();
    }

    public void addUser(ExtensiveUserInfo extensiveUserInfo) throws InstantiationException, UserAlreadyExistsException, IOException {
        User user = this._lyb.createUser(extensiveUserInfo._jqb(), extensiveUserInfo._jyd());
        user.setDescription(extensiveUserInfo._bb());
        if (extensiveUserInfo._lab() != null) {
            try {
                ObjectUtils._ot(user, "realName", extensiveUserInfo._lab(), true, true);
            }
            catch (IntrospectionException introspectionException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (extensiveUserInfo._mpd() != null) {
            Iterator iterator = extensiveUserInfo._mpd().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Group group = this._lyb.getGroup(string);
                if (group == null) continue;
                user.addToGroup(group);
            }
        }
        this._lyb.store();
    }

    public void updateUser(ExtensiveUserInfo extensiveUserInfo) throws IOException {
        User user = this._lyb.getUser(extensiveUserInfo._jqb());
        if (user != null) {
            if (!ObjectUtils._nr(user.getDescription(), extensiveUserInfo._bb())) {
                user.setDescription(extensiveUserInfo._bb());
            }
            try {
                ObjectUtils._ot(user, "realName", extensiveUserInfo._lab(), true, true);
            }
            catch (IntrospectionException introspectionException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            try {
                Set set = DefaultUserAdministrator._bce(user.getGroups());
                set.removeAll(extensiveUserInfo._mpd());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    user.removeFromGroup(this._lyb.getGroup((String)iterator.next()));
                }
                HashSet hashSet = new HashSet(extensiveUserInfo._mpd());
                hashSet.removeAll(DefaultUserAdministrator._bce(user.getGroups()));
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    user.addToGroup(this._lyb.getGroup((String)iterator.next()));
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this._lyb.store();
    }

    public BasicGroupInfo getGroup(String string) {
        String[][] stringArray;
        Group group = this._lyb.getGroup(string);
        if (group == null) {
            return null;
        }
        try {
            stringArray = DefaultUserAdministrator._bbe(group.getPermissions());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            stringArray = new String[0][3];
        }
        return new BasicGroupInfo(group.getName(), group.getDescription(), stringArray);
    }

    public static String[][] _bbe(Set set) {
        String[][] stringArray = new String[set.size()][3];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Permission permission = (Permission)iterator.next();
            stringArray[n][0] = permission.getClass().getName();
            stringArray[n][1] = permission.getName();
            stringArray[n][2] = permission.getActions();
            ++n;
        }
        return stringArray;
    }

    public static Set _bce(Set set) {
        HashSet hashSet = new HashSet();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof String) {
                    hashSet.add(e);
                    continue;
                }
                hashSet.add(((Group)e).getName());
            }
        }
        return hashSet;
    }

    public List getGroups(int n, int n2, boolean bl) {
        ArrayList<BasicGroupInfo> arrayList = new ArrayList<BasicGroupInfo>();
        UserManager userManager = this._lyb;
        do {
            int n3 = n2;
            if (n2 > userManager.getGroupCount()) {
                n3 = userManager.getGroupCount();
            }
            List list = userManager.getGroups(n, n3);
            n2 -= list.size();
            int n4 = 0;
            while (n4 < list.size()) {
                Group group = (Group)list.get(n4);
                arrayList.add(new BasicGroupInfo(group.getName(), group.getDescription(), DefaultUserAdministrator._bbe(group.getPermissions())));
                ++n4;
            }
            userManager = userManager.getParent();
        } while (bl && userManager != null);
        return arrayList;
    }
}

