/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind._ll;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.sql.DriverManagerDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class DataSourceConnection
implements ConnectionEventListener {
    public PooledConnection _hhb;
    public XAResource _hib;
    public Connection _ctb;
    public boolean _jx;
    public long _hjb;
    public boolean _hkb;
    public String _hlb;
    public PreparedStatement _hmb;
    public DataSourceConnectionContainer _fc;
    public Map _hnb;
    public ApplicationServerTransaction _hob;
    public Throwable _hpb;

    public void close(boolean bl) {
        if (this._jx) {
            return;
        }
        this._jx = true;
        if (this._hhb != null) {
            this._hhb.removeConnectionEventListener(this);
        }
        this._hkb = false;
        this._vgb();
        Object var4_2 = null;
        try {
            if (this._ctb != null) {
                this._ctb.close();
            }
        }
        catch (Throwable throwable) {
            this._fc._hi._cw("Error closing DataSource connection", throwable);
        }
        this._fc = null;
        this._ctb = null;
    }

    public void release() {
        if (!this._hkb || this._jx) {
            if (!this._hkb) {
                throw new InternalError("Was not in used mode");
            }
            return;
        }
        this._hkb = false;
        this._fc.releaseConnection(this);
    }

    public PreparedStatement getCustomStatement(String string) throws SQLException {
        PreparedStatement preparedStatement;
        if (this._jx) {
            throw new InternalError("Attempt to use closed connection");
        }
        if (this._hlb == string) {
            return this._hmb;
        }
        if (this._hnb == null) {
            this._hnb = new HashMap();
        }
        if ((preparedStatement = (PreparedStatement)this._hnb.get(string)) == null) {
            preparedStatement = this._ctb.prepareStatement(string);
            this._hnb.put(string, preparedStatement);
        }
        this._hlb = string;
        this._hmb = preparedStatement;
        return preparedStatement;
    }

    public String toString() {
        return "[DataSourceConnection " + this._ctb + "]";
    }

    public DataSourceConnection(DataSourceConnectionContainer dataSourceConnectionContainer, ApplicationServerTransaction applicationServerTransaction) throws SQLException {
        try {
            this._fc = dataSourceConnectionContainer;
            this._hob = applicationServerTransaction;
            if (applicationServerTransaction == null && dataSourceConnectionContainer._af.nonTXSource != null) {
                this._hhb = dataSourceConnectionContainer._af.nonTXSource._vjb()._vkb();
                this._ctb = this._hhb.getConnection();
                this._hhb.addConnectionEventListener(this);
            } else {
                this._hhb = dataSourceConnectionContainer._af._vjb()._vkb();
                if (applicationServerTransaction != null) {
                    this._hib = ((XAConnection)this._hhb).getXAResource();
                }
                this._hhb.addConnectionEventListener(this);
                this._ctb = DriverManagerDataSource.DEBUG ? new _ll(this._hhb.getConnection(), true) : this._hhb.getConnection();
            }
            if (this._ctb == null) {
                throw new InternalError("Received null connection from " + this._hhb);
            }
            if (dataSourceConnectionContainer._mrb() != -7) {
                this._ctb.setTransactionIsolation(dataSourceConnectionContainer._mrb());
            }
            this._hkb = true;
        }
        catch (SQLException sQLException) {
            block12: {
                try {
                    this.close(true);
                }
                catch (Throwable throwable) {
                    if (dataSourceConnectionContainer._hi == null) break block12;
                    dataSourceConnectionContainer._hi._cw("Error closing connection after SQLException", throwable);
                }
            }
            throw sQLException;
        }
        catch (Error error) {
            try {
                this.close(true);
            }
            catch (Throwable throwable) {
                this._fc._hi._cw("Error closing connection after " + error.getClass(), throwable);
            }
            throw error;
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        if (DriverManagerDataSource.DEBUG) {
            System.out.println("*** DATASOURCECONNECTION ERROR SIGNALLED: " + connectionEvent.getSource() + " ***");
        }
        ((PooledConnection)connectionEvent.getSource()).removeConnectionEventListener(this);
        this.close(false);
    }

    public void _vgb() {
        this._hlb = null;
        this._hmb = null;
        try {
            try {
                if (this._hnb != null) {
                    Iterator iterator = this._hnb.values().iterator();
                    while (iterator.hasNext()) {
                        ((PreparedStatement)iterator.next()).close();
                    }
                }
            }
            catch (SQLException sQLException) {
                this._fc._hi._cw("Error closing DataSource connection", sQLException);
            }
            Object var3_3 = null;
            if (this._hnb != null) {
                this._hnb.clear();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (this._hnb != null) {
                this._hnb.clear();
            }
            throw throwable;
        }
    }

    public void rollback() throws SQLException {
        if (this._ctb != null) {
            this._ctb.rollback();
        }
    }

    public Connection getConnection() {
        return this._ctb;
    }

    protected void finalize() {
        if (!this._jx) {
            System.err.println("DataSourceConnection was not closed!");
            if (DataSourceConnectionContainer._gy) {
                System.err.println("Debug output enabled...");
                if (this._hpb != null) {
                    this._hpb.printStackTrace();
                }
            }
            this.close(true);
        }
    }

    public void commit() throws SQLException {
        if (this._ctb != null) {
            this._ctb.commit();
        }
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        if (DriverManagerDataSource.DEBUG) {
            System.out.println("*** DATASOURCECONNECTION CLOSE SIGNALLED: " + connectionEvent.getSource() + " ***");
        }
        this.close(false);
    }

    public boolean _vhb() throws SQLException {
        if (this._ctb == null) {
            return true;
        }
        long l = HttpDateFormat._vlb();
        if (this._hjb < l) {
            if (this._ctb.isClosed()) {
                this._ctb = null;
                this.close(true);
                return true;
            }
            this._hjb = l + this._fc._hqb;
        }
        return false;
    }

    public XAResource _vib() {
        return this._hib;
    }
}

