/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind._uj;
import com.evermind.server.ejb.ChangedValue;
import com.evermind.server.ejb.DataSourceConnection;
import com.evermind.server.ejb.EvermindEntityContext;
import com.evermind.server.rmi.Replaceable;
import java.sql.SQLException;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;

public abstract class ORSet
extends AbstractSet
implements Replaceable {
    public EvermindEntityContext context;
    public Object primaryKey;
    public Object[] objects;
    public int deleted;
    public boolean used;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean remove(Object object, boolean bl) {
        try {
            if (this.objects == null) {
                this.objects = this.getObjects();
            }
            if (bl) {
                int n = 0;
                while (n < this.objects.length) {
                    Object object2 = this.objects[n];
                    if (object2 instanceof ChangedValue) {
                        ChangedValue changedValue = (ChangedValue)object2;
                        if (changedValue.newValue != null && (object == changedValue.newValue || object.equals(changedValue.newValue))) {
                            this.notifyRemovedObject(changedValue.newValue);
                            changedValue.newValue = null;
                            ++this.deleted;
                            this.used = true;
                            return true;
                        }
                    } else if (object == object2 || object.equals(object2)) {
                        this.notifyRemovedObject(object2);
                        this.objects[n] = new ChangedValue(object2, null);
                        ++this.deleted;
                        this.used = true;
                        return true;
                    }
                    ++n;
                }
                return false;
            } else {
                int n = 0;
                while (n < this.objects.length) {
                    Object[] objectArray;
                    Object object3 = this.objects[n];
                    if (object3 instanceof ChangedValue) {
                        objectArray = (Object[])object3;
                        if (objectArray.newValue != null && (object3 == objectArray.newValue || object3.equals(objectArray.newValue))) {
                            Object[] objectArray2 = new Object[this.objects.length - 1];
                            System.arraycopy(this.objects, 0, objectArray2, 0, n);
                            System.arraycopy(this.objects, n + 1, objectArray2, n, this.objects.length - (n + 1));
                            this.objects = objectArray2;
                            return true;
                        }
                    } else if (object == object3 || object.equals(object3)) {
                        objectArray = new Object[this.objects.length - 1];
                        System.arraycopy(this.objects, 0, objectArray, 0, n);
                        System.arraycopy(this.objects, n + 1, objectArray, n, this.objects.length - (n + 1));
                        this.objects = objectArray;
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            Object var8_19 = null;
            throw throwable;
        }
    }

    protected abstract boolean isImmutable();

    public EvermindEntityContext __getContext() {
        return this.context;
    }

    public void notifyRemovedObject(Object object) {
    }

    public void __setDirty(Object object) {
        this.used = true;
    }

    public boolean isUsed() {
        return this.used;
    }

    public boolean add(Object object) {
        return this.add(object, true);
    }

    public boolean add(Object object, boolean bl) {
        Object[] objectArray;
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        if (bl) {
            this.used = true;
        }
        int n = 0;
        while (n < this.objects.length) {
            objectArray = this.objects[n];
            if (objectArray instanceof ChangedValue) {
                ChangedValue changedValue = (ChangedValue)objectArray;
                if (changedValue.newValue != null && object.equals(changedValue.newValue)) {
                    changedValue.newValue = object;
                    return false;
                }
            } else if (object.equals(objectArray)) {
                this.objects[n] = object;
                return false;
            }
            ++n;
        }
        if (bl) {
            this.notifyAddedObject(object);
        }
        Object[] objectArray2 = this.objects;
        objectArray = new Object[this.objects.length + 1];
        System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        objectArray[objectArray2.length] = new ChangedValue(null, object);
        this.objects = objectArray;
        return true;
    }

    public int size() {
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        return this.objects.length - this.deleted;
    }

    public abstract void persist(DataSourceConnection var1) throws SQLException;

    public Object getReplacement() {
        return new HashSet(this);
    }

    protected void clearRemoved() {
        if (this.deleted == 0) {
            return;
        }
        int n = this.objects.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.objects[n2] instanceof ChangedValue) {
                this.objects[n2] = this.objects[n-- - 1];
                --n2;
            }
            ++n2;
        }
        if (n != this.objects.length) {
            Object[] objectArray = new Object[n];
            System.arraycopy(this.objects, 0, objectArray, 0, n);
            this.objects = objectArray;
        }
        this.deleted = 0;
    }

    public Iterator iterator() {
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        return new _uj(this);
    }

    public void initializeObject(Object object) {
    }

    public void notifyAddedObject(Object object) {
        this.initializeObject(object);
    }

    public void clear() {
        if (this.objects == null) {
            this.objects = this.getObjects();
        }
        int n = 0;
        while (n < this.objects.length) {
            if (this.objects[n] instanceof ChangedValue) {
                if (((ChangedValue)this.objects[n]).newValue != null) {
                    this.notifyRemovedObject(((ChangedValue)this.objects[n]).newValue);
                    ((ChangedValue)this.objects[n]).newValue = null;
                }
            } else {
                this.notifyRemovedObject(this.objects[n]);
                this.objects[n] = new ChangedValue(this.objects[n], null);
            }
            ++n;
        }
        this.deleted = this.objects.length;
        this.used = true;
    }

    public abstract Object[] getObjects();

    public void __clearDirty() {
    }

    public void remove(int n) {
        this.used = true;
        if (this.objects[n] instanceof ChangedValue) {
            if (((ChangedValue)this.objects[n]).newValue != null) {
                this.notifyRemovedObject(((ChangedValue)this.objects[n]).newValue);
                ++this.deleted;
                ((ChangedValue)this.objects[n]).newValue = null;
            }
        } else {
            this.notifyRemovedObject(this.objects[n]);
            ++this.deleted;
            this.objects[n] = new ChangedValue(this.objects[n], null);
        }
    }

    public boolean remove(Object object) {
        return this.remove(object, true);
    }
}

