/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind._cp;
import com.evermind.server.http.JSPPage;
import com.evermind.util.ByteString;
import java.io.File;
import java.io.Serializable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class ServletInstanceInfo
implements Serializable {
    public Servlet servlet;
    public Servlet[] pool;
    public Class type;
    public int availableCount;
    public ServletConfig config;
    public File file;
    public long binaryLastModified;
    public File sourceFile;
    public long sourceLastModified;
    public long lastModifiedCheck;
    public boolean invalidated;
    public boolean autoReload;
    public _cp application;
    public ByteString name;
    public boolean shared;
    public boolean singleThreaded;
    public boolean sandboxed;
    public boolean destroyed;
    public boolean active;
    public boolean unavailable;
    public long unavailableTime;
    public String unavailableReason;
    public JSPPage page;

    public synchronized void _ol() {
        if (this.servlet != null) {
            if (!this.destroyed) {
                this.servlet.destroy();
            }
            this.destroyed = true;
        }
        if (this.pool != null) {
            try {
                int n = 0;
                while (n < this.availableCount) {
                    this.pool[n].destroy();
                    ++n;
                }
            }
            finally {
                Object var3_2 = null;
                this.pool = null;
                this.availableCount = 0;
            }
        }
    }

    public synchronized void _ycb(Servlet servlet) {
        if (this.pool == null || this.availableCount >= this.pool.length) {
            Servlet[] servletArray = new Servlet[this.pool == null ? 4 : this.pool.length * 2];
            if (this.pool != null) {
                System.arraycopy(this.pool, 0, servletArray, 0, this.availableCount);
            }
            this.pool = servletArray;
        }
        this.pool[this.availableCount++] = servlet;
    }

    public void finalize() {
        this._ol();
    }

    public synchronized Servlet _pu() throws ServletException, ClassNotFoundException {
        if (this.availableCount > 0) {
            return this.pool[this.availableCount += -1];
        }
        if (this.servlet != null) {
            Servlet servlet = this.servlet;
            this.servlet = null;
            return servlet;
        }
        try {
            Servlet servlet = (Servlet)this.type.newInstance();
            servlet.init(this.config);
            return servlet;
        }
        catch (ClassCastException classCastException) {
            throw new ClassNotFoundException(this.type.toString() + " does not implement Servlet", classCastException);
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(this.type.toString(), exception);
        }
    }
}

