/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.loadbalancer;

import com.evermind._br;
import com.evermind._bz;
import com.evermind._ca;
import com.evermind._cb;
import com.evermind._cc;
import com.evermind._cd;
import com.evermind._ce;
import com.evermind._cg;
import com.evermind._cub;
import com.evermind._cvb;
import com.evermind._sy;
import com.evermind.util.ByteString;
import com.evermind.util.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import javax.jms.JMSException;

public class LoadBalancer
implements Runnable {
    public boolean _gwb;
    public _cd _xt;
    public ServerSocket _kg;
    public ThreadPool _gn;
    public _ce _gxb;
    public _cg _gyb;
    public _br _gzb;
    public boolean _hab = true;
    public _ca _de = new _ca(this, null);
    public int _hbb;
    public _cb[] _hcb = new _cb[16];
    public int _hdb;
    public _cc[] _heb = new _cc[16];

    public boolean _ugb() {
        return this._hab;
    }

    public static void _fk(String string) {
        System.err.println(string);
        System.out.println("Usage:");
        System.out.println("-config - path to the load-balancer.xml config file, the default is config/load-balancer.xml");
        System.out.println("-host - host/address to listen to for HTTP connections");
        System.out.println("-port - port to listen to for HTTP connections");
        System.out.println("-dontUseSessionID - specifies the balancer not to scan for Servlet session IDs as a means of identifying clients (useful when for instance balancing SSL sites)");
        System.out.println("-dontUseIP - specifies the balancer not to route connections based on IP if no session exists/is scanned for");
        System.out.println("-dontUseKeepAlives - specifies the balancer not to maintain keep-alives. This is useful if number of open sockets/used threads is a problem on the balancer but it will increase network traffic and CPU usage (and slow down client requests).");
        System.out.println("-minimumIsland - the minimum island to add to alive servers list, useful when using several balancer instances");
        System.out.println("-maximumIsland - the maximum island to add to alive servers list, useful when using several balancer instances");
        System.out.println("-selectiontype - how to select servers, the default is random, options are: 'random', 'first'");
    }

    public synchronized _cc _uhb() {
        if (this._hdb > 0) {
            return this._heb[this._hdb += -1];
        }
        return new _cc(this);
    }

    public Socket _uib(ByteString[] byteStringArray, InetAddress inetAddress, ByteString byteString, Object object) throws InterruptedException {
        return this._de._uib(inetAddress, byteString, object);
    }

    public LoadBalancer(_cd _cd2, _ce _ce2, ThreadPool threadPool, _br _br2, boolean bl) throws InstantiationException {
        this._xt = _cd2;
        this._gwb = bl;
        this._gxb = _ce2;
        this._gn = threadPool;
        this._de._hfb = _cd2._unb();
        this._de._hgb = _cd2._uob();
        this._hab = _cd2._ugb();
        this._gzb = _br2;
        _br2._lj(new _cub(this));
        if (_cd2._upb().equals("first")) {
            this._de._uqb(new _sy());
        } else {
            this._de._uqb(new _cvb());
        }
        List list = _cd2._urb();
        int n = 0;
        while (n < list.size()) {
            this._de._usb((_bz)list.get(n), false);
            ++n;
        }
        this._de._upb()._de(this);
        this._gyb = new _cg("islands", this);
        _ce2._utb("islands", this._gyb);
        try {
            this._kg = new ServerSocket(_cd2._fx(), 30, _cd2._fu());
        }
        catch (IOException iOException) {
            throw new InstantiationException("Error listening for HTTP/HTTPS connections at " + _cd2._fu() + ":" + _cd2._fx() + ": " + iOException.getMessage());
        }
    }

    public synchronized void _ujb(_cb _cb2) {
        if (this._hbb >= this._hcb.length) {
            _cb[] _cbArray = new _cb[this._hcb.length * 2];
            System.arraycopy(this._hcb, 0, _cbArray, 0, this._hcb.length);
            this._hcb = _cbArray;
        }
        this._hcb[this._hbb++] = _cb2;
    }

    public synchronized void _ujb(_cc _cc2) {
        if (this._hdb >= this._heb.length) {
            _cc[] _ccArray = new _cc[this._heb.length * 2];
            System.arraycopy(this._heb, 0, _ccArray, 0, this._heb.length);
            this._heb = _ccArray;
        }
        this._heb[this._hdb++] = _cc2;
    }

    public static void main(String[] stringArray) throws UnknownHostException, JMSException, IOException {
        ThreadPool threadPool = new ThreadPool(Thread.currentThread().getThreadGroup(), false);
        _ce _ce2 = new _ce(null, InetAddress.getByName("230.0.0.2"), 27512, 0L);
        _br _br2 = new _br(threadPool);
        try {
            Object object;
            int n = 0;
            String string = "config/load-balancer.xml";
            if (stringArray.length >= 2 && stringArray[0].equalsIgnoreCase("-config")) {
                string = stringArray[1];
                n = 2;
            }
            _cd _cd2 = new _cd();
            if (new File(string).exists()) {
                _cd2._de(new File(string).toURL());
            }
            boolean bl = false;
            while (n < stringArray.length) {
                if (((String)(object = stringArray[n++])).equals("-host")) {
                    if (n == stringArray.length) {
                        LoadBalancer._fk("Expected hostname");
                        _ce2._ol();
                        System.exit(1);
                    }
                    _cd2._uub(stringArray[n++]);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-dontUseSessionID")) {
                    _cd2._uvb(false);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-dontUseKeepAlives")) {
                    _cd2._uwb(false);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-?")) {
                    LoadBalancer._fk("");
                    _ce2._ol();
                    System.exit(1);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-dontUseIP")) {
                    _cd2._uxb(false);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-debug")) {
                    bl = true;
                    continue;
                }
                if (((String)object).equals("-config")) {
                    LoadBalancer._fk("-config switch must appear first in the list of switches");
                    _ce2._ol();
                    System.exit(1);
                    continue;
                }
                if (((String)object).equals("-port")) {
                    if (n == stringArray.length) {
                        LoadBalancer._fk("Expected port number");
                        _ce2._ol();
                        System.exit(1);
                    }
                    _cd2._uyb(Integer.parseInt(stringArray[n++]));
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-minimumIsland")) {
                    if (n == stringArray.length) {
                        LoadBalancer._fk("Expected island ID");
                        _ce2._ol();
                        System.exit(1);
                    }
                    _cd2._uzb(Integer.parseInt(stringArray[n++]));
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-maximumIsland")) {
                    if (n == stringArray.length) {
                        LoadBalancer._fk("Expected island ID");
                        _ce2._ol();
                        System.exit(1);
                    }
                    _cd2._vab(Integer.parseInt(stringArray[n++]));
                    continue;
                }
                if (((String)object).equalsIgnoreCase("-selectiontype")) {
                    if (n == stringArray.length) {
                        LoadBalancer._fk("Expected selection type");
                        _ce2._ol();
                        System.exit(1);
                    }
                    _cd2._vbb(stringArray[n++]);
                    continue;
                }
                LoadBalancer._fk("Unexpected switch: " + (String)object);
                _br2._lf();
                threadPool._ol();
                _ce2._ol();
                System.exit(1);
            }
            threadPool.launch(_ce2);
            _br2._ll();
            object = new LoadBalancer(_cd2, _ce2, threadPool, _br2, bl);
            ((LoadBalancer)object)._ll();
            System.out.println("Balancer initialized...");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Error starting balancer: " + instantiationException.getMessage());
            _ce2._ol();
            threadPool._ol();
        }
    }

    public void _ukb() {
        this._de._ukb();
    }

    public void _ll() {
        this._gn.launch(this);
    }

    public synchronized void _gi(String[] stringArray, InetAddress inetAddress, int n, int n2) {
        this._de._gi(inetAddress, n, n2);
    }

    public synchronized _cb _ulb() {
        if (this._hbb > 0) {
            return this._hcb[this._hbb += -1];
        }
        return new _cb(this);
    }

    public ThreadPool _umb() {
        return this._gn;
    }

    public void run() {
        while (true) {
            try {
                Object object;
                Socket socket = this._kg.accept();
                if (this._de._hfb) {
                    object = this._ulb();
                    ((_cb)object)._de(socket);
                    continue;
                }
                object = this._uhb();
                ((_cc)object)._de(socket);
            }
            catch (IOException iOException) {
            }
        }
    }

    public synchronized void _gh(String[] stringArray, InetAddress inetAddress, int n, int n2, long l) {
        if (n2 < this._xt._vcb() || n2 > this._xt._vdb()) {
            return;
        }
        this._de._gh(inetAddress, n, n2, l);
    }
}

