/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.sql;

import com.evermind._ll;
import com.evermind._pe;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;

public class DriverManagerDataSource
implements DataSource,
Serializable {
    public static final boolean DEBUG = _pe._di("jdbc.debug", false);
    private String name;
    public String url;
    public transient Driver _cqc;
    public Properties driverProperties;
    public transient boolean _crc;
    public String driverName;
    public String username;
    public String password;
    public transient PrintWriter _csc;
    public int loginTimeout;
    public boolean defaultAutoCommit = true;
    public String location;

    public String _gp() {
        return this.location;
    }

    public void _uoc(Driver driver) {
        this._cqc = driver;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public String toString() {
        return this.url;
    }

    public void setLogin(String string, String string2) {
        this.username = string;
        this.password = string2;
    }

    public void setURL(String string) {
        this.url = string;
        if (this._csc != null) {
            this._csc.println(this + ": Started");
        }
    }

    public Connection getConnection() throws SQLException {
        if (this._csc != null) {
            this._csc.println(this + ": Opened connection");
        }
        if (this._cqc != null) {
            Connection connection;
            if (this.driverProperties == null) {
                this.driverProperties = new Properties();
                if (this.username != null) {
                    ((Hashtable)this.driverProperties).put("user", this.username);
                }
                if (this.password != null) {
                    ((Hashtable)this.driverProperties).put("password", this.password);
                }
            }
            if ((connection = this._cqc.connect(this.url, this.driverProperties)) == null) {
                throw new SQLException("The database driver (" + this._cqc + ") returned refusing to connect to the URL " + this.url);
            }
            if (DEBUG) {
                connection = new _ll(connection, true);
            }
            return connection;
        }
        if (!this._crc && this.driverName != null) {
            try {
                this._upc(this.driverName, Thread.currentThread().getContextClassLoader());
                return this.getConnection(this.username, this.password);
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException("Error loading driver '" + this.driverName + "': " + instantiationException.getMessage());
            }
        }
        if (this.username == null || this.password == null) {
            Connection connection = DriverManager.getConnection(this.url);
            if (DEBUG) {
                connection = new _ll(connection, true);
            }
            return connection;
        }
        Connection connection = DriverManager.getConnection(this.url, this.username, this.password);
        if (DEBUG) {
            connection = new _ll(connection, true);
        }
        return connection;
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (this._csc != null) {
            this._csc.println(this + ": Opened connection");
        }
        if (this._cqc != null) {
            Properties properties = new Properties();
            ((Hashtable)properties).put("user", string);
            ((Hashtable)properties).put("password", string2);
            Connection connection = this._cqc.connect(this.url, properties);
            if (!this.defaultAutoCommit) {
                connection.setAutoCommit(false);
            }
            if (DEBUG) {
                connection = new _ll(connection, this.defaultAutoCommit);
            }
            return connection;
        }
        if (!this._crc && this.driverName != null) {
            try {
                this._upc(this.driverName, Thread.currentThread().getContextClassLoader());
                return this.getConnection(string, string2);
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException("Error loading driver '" + this.driverName + "': " + instantiationException.getMessage());
            }
        }
        Connection connection = DriverManager.getConnection(this.url, string, string2);
        if (!this.defaultAutoCommit) {
            connection.setAutoCommit(false);
        }
        if (DEBUG) {
            connection = new _ll(connection, !this.defaultAutoCommit);
        }
        return connection;
    }

    public PrintWriter getLogWriter() {
        return this._csc;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._csc = printWriter;
    }

    public void _upc(String string, ClassLoader classLoader) throws InstantiationException {
        this._crc = true;
        this.driverName = string;
        try {
            Class.forName(string, true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                this._uoc((Driver)Class.forName(string, true, classLoader).newInstance());
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new InstantiationException("DriverManagerDataSource driver '" + string + "' not found");
            }
            catch (ClassCastException classCastException) {
                throw new InstantiationException("Class '" + this._cqc + "' is not a java.sql.Driver");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InstantiationException("Error instantiating '" + this._cqc + "' access exception: " + illegalAccessException.getMessage());
            }
        }
    }

    public void _gu(String string) {
        this.location = string;
    }
}

