/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.xml;

import com.evermind._iib;
import com.evermind._of;
import com.evermind._tx;
import com.evermind._ud;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static boolean _rfb(String string) {
        return string.startsWith("#");
    }

    public static String _cvc(Node node, String string) {
        Node node2 = XMLUtils._ctc(node, string);
        if (node2 == null) {
            return null;
        }
        return XMLUtils.getStringValue(node2);
    }

    public static int _ttc(String string, String string2) throws InstantiationException {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InstantiationException("Illegal " + string + " value: '" + string2 + "', must be numeric");
        }
    }

    public static String _mw(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public static String _ba(String string) {
        if (string == null) {
            return "";
        }
        if (string.indexOf(38) >= 0) {
            string = _tx._la(string, '&', "&amp;");
        }
        if (string.indexOf(60) >= 0) {
            string = _tx._la(string, '<', "&lt;");
        }
        if (string.indexOf(62) >= 0) {
            string = _tx._la(string, '>', "&gt;");
        }
        if (string.indexOf(34) >= 0) {
            string = _tx._la(string, '\"', "&quot;");
        }
        return string;
    }

    public static Document getDocument(InputSource inputSource, ErrorHandler errorHandler, EntityResolver entityResolver, boolean bl) throws SAXException, IOException, InstantiationException {
        try {
            if ("xerces".equals(System.getProperty("xml.parser"))) {
                return _iib.getXercesDocument(inputSource, errorHandler, entityResolver, bl);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return _ud.getJavaxDocument(inputSource, errorHandler, entityResolver, bl);
    }

    public static Node _lyb(byte[] byArray, EntityResolver entityResolver, String string) throws InstantiationException, IOException {
        try {
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
            Document document = XMLUtils.getDocument(inputSource, null, entityResolver, false);
            if (document == null) {
                throw new InstantiationException("Error parsing " + string + ", empty document");
            }
            Element element = document.getDocumentElement();
            if (element == null) {
                throw new InstantiationException("Error parsing " + string + ", empty document");
            }
            return element;
        }
        catch (SAXException sAXException) {
            throw new InstantiationException("Error parsing " + string + ": " + sAXException.getMessage());
        }
    }

    public static boolean _osc(String string, String string2) throws InstantiationException {
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        throw new InstantiationException(string + " must be either 'true' or 'false', not '" + string2 + "'");
    }

    public static void _fwd(Collection collection, String string, PrintWriter printWriter, String string2) throws IOException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            printWriter.println(string2 + "<" + string + ">" + XMLUtils._ba(iterator.next().toString()) + "</" + string + ">");
        }
    }

    public static void _jlc(Collection collection, String string, String string2, PrintWriter printWriter, String string3) throws IOException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            printWriter.println(string3 + "<" + string + " " + string2 + "=\"" + XMLUtils._ba(iterator.next().toString()) + "\" />");
        }
    }

    public static long _orc(String string, String string2) throws InstantiationException {
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InstantiationException("Illegal " + string + " value: '" + string2 + "', must be numeric");
        }
    }

    public static void _bc(Collection collection, PrintWriter printWriter, String string) throws IOException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((_of)iterator.next())._av(printWriter, string);
        }
    }

    public static void _mkc(Map map, String string, PrintWriter printWriter, String string2, String string3, String string4) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            printWriter.println(string4 + "<" + string + " " + string2 + "=\"" + XMLUtils._ba(entry.getKey().toString()) + "\" " + string3 + "=\"" + XMLUtils._ba(entry.getValue().toString()) + "\" />");
        }
    }

    public static String getStringValue(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return "";
        }
        String string = node2.getNodeValue();
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static Node _ctc(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                String string2 = node2.getNodeName();
                if (string2.equals(string)) {
                    return node2;
                }
                ++n;
            }
        }
        return null;
    }
}

