/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    public static Hashtable parsePostData(int length, ServletInputStream in) {
        byte[] postedBytes = null;
        if (length <= 0) {
            return new Hashtable();
        }
        if (in == null) {
            throw new IllegalArgumentException();
        }
        try {
            int inputLength;
            postedBytes = new byte[length];
            int offset = 0;
            do {
                if ((inputLength = in.read(postedBytes, offset, length - offset)) > 0) continue;
                throw new IOException("premature end of stream");
            } while (length - (offset += inputLength) > 0);
        }
        catch (IOException e) {
            return new Hashtable();
        }
        String postedBody = new String(postedBytes, 0, length);
        return HttpUtils.parseQueryString(postedBody);
    }

    private static String parseName(String s, StringBuffer sb) {
        sb.setLength(0);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    break;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal %XX code");
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) break;
                        ++i;
                        break;
                    }
                }
                default: {
                    sb.append(c);
                    break;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static Hashtable parseQueryString(String string) {
        if (string == null) {
            throw new NullPointerException("queryString was null");
        }
        String[] values = null;
        Hashtable<String, String[]> map = new Hashtable<String, String[]>();
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(string, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException("Missing '=' in attribute key/value pair");
            }
            String key = HttpUtils.parseName(pair.substring(0, pos), buffer);
            String value = HttpUtils.parseName(pair.substring(pos + 1, pair.length()), buffer);
            if (map.containsKey(key)) {
                String[] oldVals = (String[])map.get(key);
                values = new String[oldVals.length + 1];
                int i = 0;
                while (i < oldVals.length) {
                    values[i] = oldVals[i];
                    ++i;
                }
                values[oldVals.length] = value;
            } else {
                values = new String[]{value};
            }
            map.put(key, values);
        }
        return map;
    }

    public static StringBuffer getRequestURL(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        String urlPath = req.getRequestURI();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        url.append(urlPath);
        return url;
    }
}

