/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.client;

import java.applet.Applet;
import java.awt.Graphics;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.res.XSLMessages;

public class XSLTProcessorApplet
extends Applet {
    TransformerFactory m_tfactory = null;
    private String m_styleURL;
    private String m_documentURL;
    private final String PARAM_styleURL = "styleURL";
    private final String PARAM_documentURL = "documentURL";
    private String m_styleURLOfCached = null;
    private String m_documentURLOfCached = null;
    private URL m_codeBase = null;
    private String m_treeURL = null;
    private URL m_documentBase = null;
    private transient Thread m_callThread = null;
    private transient TrustedAgent m_trustedAgent = null;
    private transient Thread m_trustedWorker = null;
    private transient String m_htmlText = null;
    private transient String m_sourceText = null;
    private transient String m_nameOfIDAttrOfElemToModify = null;
    private transient String m_elemIdToModify = null;
    private transient String m_attrNameToSet = null;
    private transient String m_attrValueToSet = null;
    transient String m_key;
    transient String m_expression;

    static /* synthetic */ Thread access$0(XSLTProcessorApplet $0) {
        return $0.m_trustedWorker;
    }

    static /* synthetic */ String access$1(XSLTProcessorApplet $0) {
        return $0.m_htmlText;
    }

    static /* synthetic */ String access$3(XSLTProcessorApplet $0) {
        return $0.m_sourceText;
    }

    public void destroy() {
        if (this.m_trustedWorker != null) {
            this.m_trustedWorker.stop();
            this.m_trustedWorker = null;
        }
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public String escapeString(String s) {
        StringBuffer sb = new StringBuffer();
        int length = s.length();
        int i = 0;
        while (i < length) {
            char ch = s.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
            } else if (ch == '>') {
                sb.append("&gt;");
            } else if (ch == '&') {
                sb.append("&amp;");
            } else if (ch >= '\ud800' && ch < '\udc00') {
                int next;
                if (i + 1 >= length) {
                    throw new RuntimeException(XSLMessages.createMessage(100, new Object[]{Integer.toHexString(ch)}));
                }
                if ((next = s.charAt(++i)) < 56320 || next >= 57344) {
                    throw new RuntimeException(XSLMessages.createMessage(100, new Object[]{String.valueOf(Integer.toHexString(ch)) + " " + Integer.toHexString(next)}));
                }
                next = (ch - 55296 << 10) + next - 56320 + 65536;
                sb.append("&#x");
                sb.append(Integer.toHexString(next));
                sb.append(";");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public void freeCache() {
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public String getAppletInfo() {
        return "Name: XSLTProcessorApplet\r\nAuthor: Scott Boag";
    }

    public String getHtmlText() {
        this.m_trustedAgent.m_getData = true;
        this.m_callThread = Thread.currentThread();
        try {
            Thread thread = this.m_callThread;
            synchronized (thread) {
                this.m_callThread.wait();
            }
        }
        catch (InterruptedException ie) {
            System.out.println(ie.getMessage());
        }
        return this.m_htmlText;
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"styleURL", "String", "URL to an XSL stylesheet"}, {"documentURL", "String", "URL to an XML document"}};
        return info;
    }

    public String getResultTreeAsText() throws Exception {
        return this.escapeString(this.getHtmlText());
    }

    private String getSource() throws TransformerException {
        StringWriter osw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)osw, false);
        String text = "";
        try {
            URL docURL = new URL(this.m_documentBase, this.m_treeURL);
            TransformerFactory transformerFactory = this.m_tfactory;
            synchronized (transformerFactory) {
                Transformer transformer = this.m_tfactory.newTransformer();
                StreamSource source = new StreamSource(docURL.toString());
                StreamResult result = new StreamResult(pw);
                transformer.transform(source, result);
                text = osw.toString();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (Exception any_error) {
            any_error.printStackTrace();
        }
        return text;
    }

    public String getSourceTreeAsText() throws Exception {
        return this.getTreeAsText(this.m_documentURL);
    }

    public String getStyleTreeAsText() throws Exception {
        return this.getTreeAsText(this.m_styleURL);
    }

    public String getTreeAsText(String treeURL) throws IOException {
        this.m_treeURL = treeURL;
        this.m_trustedAgent.m_getData = true;
        this.m_trustedAgent.m_getSource = true;
        this.m_callThread = Thread.currentThread();
        try {
            Thread thread = this.m_callThread;
            synchronized (thread) {
                this.m_callThread.wait();
            }
        }
        catch (InterruptedException ie) {
            System.out.println(ie.getMessage());
        }
        return this.m_sourceText;
    }

    public void init() {
        String param = this.getParameter("styleURL");
        if (param != null) {
            this.setStyleURL(param);
        }
        if ((param = this.getParameter("documentURL")) != null) {
            this.setDocumentURL(param);
        }
        this.m_codeBase = this.getCodeBase();
        this.m_documentBase = this.getDocumentBase();
        this.resize(320, 240);
    }

    public void paint(Graphics g) {
    }

    private String processTransformation() throws TransformerException {
        String htmlData = null;
        this.showStatus("Waiting for Transformer and Parser to finish loading and JITing...");
        TransformerFactory transformerFactory = this.m_tfactory;
        synchronized (transformerFactory) {
            URL documentURL = null;
            URL styleURL = null;
            StringWriter osw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)osw, false);
            StreamResult result = new StreamResult(pw);
            this.showStatus("Begin Transformation...");
            try {
                documentURL = new URL(this.m_codeBase, this.m_documentURL);
                StreamSource xmlSource = new StreamSource(documentURL.toString());
                styleURL = new URL(this.m_codeBase, this.m_styleURL);
                StreamSource xslSource = new StreamSource(styleURL.toString());
                Transformer transformer = this.m_tfactory.newTransformer(xslSource);
                if (this.m_key != null) {
                    transformer.setParameter(this.m_key, this.m_expression);
                }
                transformer.transform(xmlSource, result);
            }
            catch (TransformerConfigurationException tfe) {
                tfe.printStackTrace();
                System.exit(-1);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            this.showStatus("Transformation Done!");
            htmlData = osw.toString();
        }
        return htmlData;
    }

    public void setDocumentURL(String urlString) {
        this.m_documentURL = urlString;
    }

    public void setStyleSheetAttribute(String nameOfIDAttrOfElemToModify, String elemId, String attrName, String value) {
        this.m_nameOfIDAttrOfElemToModify = nameOfIDAttrOfElemToModify;
        this.m_elemIdToModify = elemId;
        this.m_attrNameToSet = attrName;
        this.m_attrValueToSet = value;
    }

    public void setStyleURL(String urlString) {
        this.m_styleURL = urlString;
    }

    public void setStylesheetParam(String key, String expr) {
        this.m_key = key;
        this.m_expression = expr;
    }

    public void start() {
        this.m_trustedAgent = new TrustedAgent();
        Thread currentThread = Thread.currentThread();
        this.m_trustedWorker = new Thread(currentThread.getThreadGroup(), this.m_trustedAgent);
        this.m_trustedWorker.start();
        try {
            this.m_tfactory = TransformerFactory.newInstance();
            this.showStatus("Causing Transformer and Parser to Load and JIT...");
            StringReader xmlbuf = new StringReader("<?xml version='1.0'?><foo/>");
            StringReader xslbuf = new StringReader("<?xml version='1.0'?><xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'><xsl:template match='foo'><out/></xsl:template></xsl:stylesheet>");
            PrintWriter pw = new PrintWriter(new StringWriter());
            TransformerFactory transformerFactory = this.m_tfactory;
            synchronized (transformerFactory) {
                Templates templates = this.m_tfactory.newTemplates(new StreamSource(xslbuf));
                Transformer transformer = templates.newTransformer();
                transformer.transform(new StreamSource(xmlbuf), new StreamResult(pw));
            }
            System.out.println("Primed the pump!");
            this.showStatus("Ready to go!");
        }
        catch (Exception e) {
            this.showStatus("Could not prime the pump!");
            System.out.println("Could not prime the pump!");
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.m_trustedWorker != null) {
            this.m_trustedWorker.stop();
            this.m_trustedWorker = null;
        }
        this.m_styleURLOfCached = null;
        this.m_documentURLOfCached = null;
    }

    public String transformToHtml(String doc) {
        if (doc != null) {
            this.m_documentURL = doc;
        }
        this.m_styleURL = null;
        return this.getHtmlText();
    }

    public String transformToHtml(String doc, String style) {
        if (doc != null) {
            this.m_documentURL = doc;
        }
        if (style != null) {
            this.m_styleURL = style;
        }
        return this.getHtmlText();
    }

    class TrustedAgent
    implements Runnable {
        public boolean m_getData = false;
        public boolean m_getSource = false;

        TrustedAgent() {
        }

        public void run() {
            while (true) {
                Thread.yield();
                if (this.m_getData) {
                    Thread thread;
                    Object var2_3;
                    try {
                        try {
                            this.m_getData = false;
                            XSLTProcessorApplet.this.m_htmlText = null;
                            XSLTProcessorApplet.this.m_sourceText = null;
                            if (this.m_getSource) {
                                this.m_getSource = false;
                                XSLTProcessorApplet.this.m_sourceText = XSLTProcessorApplet.this.getSource();
                            } else {
                                XSLTProcessorApplet.this.m_htmlText = XSLTProcessorApplet.this.processTransformation();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        var2_3 = null;
                    }
                    catch (Throwable throwable) {
                        var2_3 = null;
                        thread = XSLTProcessorApplet.this.m_callThread;
                        synchronized (thread) {
                            XSLTProcessorApplet.this.m_callThread.notify();
                        }
                        throw throwable;
                    }
                    thread = XSLTProcessorApplet.this.m_callThread;
                    synchronized (thread) {
                        XSLTProcessorApplet.this.m_callThread.notify();
                    }
                }
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

