package com.evermind.ejb.taglib;

import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

public class IterateTag extends BodyTagSupport
{
	private Iterator iterator;
	private String type;
	private int pos;
	private int max = -1;

	public void setCollection(Collection collection)
	{
		this.iterator = collection.iterator();
	}

	public void setType(String type)
	{
		this.type = type;
	}

	public void setMax(int max)
	{
		this.max = max;
	}

	public int doStartTag() throws JspException
	{
		return doAfterBody();
	}
	
	public int doEndTag()
	{
		this.max = -1;
		this.pos = 0;
		
		return EVAL_PAGE;
	}
	
	public int doAfterBody() throws JspException
	{
		if(iterator.hasNext() && (max < 0 || pos++ < max))
		{
			pageContext.setAttribute(this.getId(), iterator.next());
			return BodyTag.EVAL_BODY_TAG;
		}
		else
		{
			try
			{
				if(bodyContent != null)
					bodyContent.writeOut(bodyContent.getEnclosingWriter());
			}
			catch(java.io.IOException e)
			{
				throw new JspException("IO Error: " + e.getMessage());
			}

			return BodyTag.SKIP_BODY;
		}
	}
}
