package com.evermind.ejb;

import java.util.*;
import javax.ejb.*;
import java.rmi.RemoteException;

public interface NewsItemHome extends EJBHome
{
	public NewsItem create(int id) throws CreateException, RemoteException;
	public NewsItem create(NewsItem parent, Date date, String subject, String text) throws CreateException, RemoteException;

	public NewsItem findByPrimaryKey(int key) throws RemoteException, FinderException;
	public Collection findAll() throws RemoteException, FinderException;
	public Collection findByPeriod(Date start, Date end) throws RemoteException, FinderException;
	public Collection findByContent(String content) throws RemoteException, FinderException;
	public Collection findByParent(NewsItem parent) throws RemoteException, FinderException;
	
	/**
	 * Orion-specific finder specification to ease installtion (optional).
	 */
	public static final String findByParent_query = "$1 = $parent";
}
