package com.evermind.ejb;

import java.util.*;

/** 
 * Data holder passed between the tiers etc, immutable.
 */
public class NewsView implements java.io.Serializable
{
	private int id; // Integer primary key for convenience
	private int parentID; // The parent, null if this is not a reply
	private String submitter; // User who submitted the article
	private String subject; // Subject of the article
	private String text; // Content/body of the article
	private Date date; // Time it was created/posted
	private Locale locale; // Locale of the user submitting it

	public NewsView(int id, int parentID, String submitter, String subject, String text, Date date, Locale locale)
	{
		this.id = id;
		this.parentID = parentID;
		this.submitter = submitter;
		this.subject = subject;
		this.text = text;
		this.date = date;
		this.locale = locale;
	}
	
	public int getId()
	{
		return this.id;
	}
	
	public int getParentId()
	{
		return this.parentID;
	}
	
	public String getSubmitter()
	{
		return this.submitter;
	}

	public String getSubject()
	{
		return this.subject;
	}
	
	public String getText()
	{
		return this.text;
	}
	
	public Date getDate()
	{
		return this.date;
	}

	public Locale getLocale()
	{
		return this.locale;
	}
}
