package com.evermind.ejb.taglib;

import javax.ejb.*;
import javax.naming.*;
import javax.servlet.jsp.*;
import javax.servlet.http.*;
import javax.servlet.jsp.tagext.*;

public class CreateBeanTag extends TagSupport
{
	private Object instance;

	public void setInstance(Object instance)
	{
		this.instance = instance;
	}

	public int doStartTag() throws JspTagException
	{
		if(instance == null)
			throw new NullPointerException("instance was null");

		UseBeanTag beanTag = (UseBeanTag)TagSupport.findAncestorWithClass(this, UseBeanTag.class);
		
		if(beanTag == null)
			throw new JspTagException("ejb:createBean tags must always appear within a ejb:useBean tag");
		
		try
		{
			EJBObject instance = (EJBObject)javax.rmi.PortableRemoteObject.narrow(this.instance, Class.forName(beanTag.type, true, pageContext.getPage().getClass().getClassLoader()));
			pageContext.setAttribute(beanTag.getId(), instance);
			
			if(beanTag.scope != null)
			{
				if(beanTag.scope.equals("session"))
				{
					HttpSession session = pageContext.getSession();

					if(session != null)
						session.setAttribute(beanTag.getId(), instance);
				}
				else if(beanTag.scope.equals("request"))
				{
					pageContext.getRequest().setAttribute(beanTag.getId(), instance);
				}
				else if(beanTag.scope.equals("application"))
				{
					pageContext.getServletContext().setAttribute(beanTag.getId(), instance);
				}
			}
		}
		catch(ClassNotFoundException e)
		{
			throw new JspTagException("EJB class not found: " + beanTag.type + " (" + e.getMessage() + ")");
		}
		
		return SKIP_BODY;
	}
}
